/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.collections;

import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TreeEdgeIterator
implements Iterator {
    private Iterator m_nodeIterator;
    private Iterator m_edgeIterator;
    private TreeNode m_curNode;
    private Edge m_next;

    public TreeEdgeIterator(Iterator iterator) {
        this.m_nodeIterator = iterator;
        if (iterator.hasNext()) {
            this.m_curNode = (TreeNode)iterator.next();
            this.m_edgeIterator = this.m_curNode.getChildEdges();
        }
        this.m_next = this.findNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.m_next != null;
    }

    public Object next() {
        if (this.m_next == null) {
            throw new NoSuchElementException("No next item in iterator");
        }
        Edge edge = this.m_next;
        this.m_next = this.findNext();
        return edge;
    }

    private Edge findNext() {
        while (true) {
            if (this.m_edgeIterator != null && this.m_edgeIterator.hasNext()) {
                return (Edge)this.m_edgeIterator.next();
            }
            if (!this.m_nodeIterator.hasNext()) break;
            this.m_curNode = (TreeNode)this.m_nodeIterator.next();
            this.m_edgeIterator = this.m_curNode.getChildEdges();
        }
        this.m_curNode = null;
        this.m_nodeIterator = null;
        this.m_edgeIterator = null;
        return null;
    }
}

