/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.collections;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class WrapAroundIterator
implements Iterator {
    private int m_cur;
    private int m_count;
    private int m_size;
    private List m_items;

    public WrapAroundIterator(List list, int n) {
        this(list, n, list.size() - 1);
    }

    public WrapAroundIterator(List list, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        this.m_items = list;
        this.m_cur = n;
        this.m_count = 0;
        this.m_size = n2 + 1;
    }

    public boolean hasNext() {
        return this.m_count < this.m_size;
    }

    public Object next() {
        if (this.m_count >= this.m_size) {
            throw new NoSuchElementException("Iterator has no next element.");
        }
        int n = this.m_cur++;
        this.m_cur %= this.m_size;
        ++this.m_count;
        return this.m_items.get(n);
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

