/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.focus;

import edu.berkeley.guir.prefuse.event.FocusEvent;
import edu.berkeley.guir.prefuse.event.FocusEventMulticaster;
import edu.berkeley.guir.prefuse.event.FocusListener;
import edu.berkeley.guir.prefuse.focus.FocusSet;
import edu.berkeley.guir.prefuse.graph.Entity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultFocusSet
implements FocusSet {
    private Set m_foci = new LinkedHashSet();
    private ArrayList m_tmp = new ArrayList();
    private FocusListener m_listener;

    public void addFocusListener(FocusListener focusListener) {
        this.m_listener = FocusEventMulticaster.add(this.m_listener, focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.m_listener = FocusEventMulticaster.remove(this.m_listener, focusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Entity entity) {
        boolean bl;
        DefaultFocusSet defaultFocusSet = this;
        synchronized (defaultFocusSet) {
            bl = this.m_foci.add(entity);
        }
        if (bl && this.m_listener != null) {
            this.m_listener.focusChanged(new FocusEvent(this, 0, new Entity[]{entity}, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection collection) {
        ArrayList arrayList = this.m_tmp;
        synchronized (arrayList) {
            Entity[] entityArray = this;
            synchronized (this) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Entity)) {
                        throw new IllegalArgumentException("All foci must be of type Entity");
                    }
                    if (!this.m_foci.add(e) || this.m_listener == null) continue;
                    this.m_tmp.add(e);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (this.m_listener != null && this.m_tmp.size() > 0) {
                    entityArray = this.m_tmp.toArray(FocusEvent.EMPTY);
                    this.m_listener.focusChanged(new FocusEvent((FocusSet)this, 0, entityArray, null));
                }
                this.m_tmp.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Entity entity) {
        boolean bl;
        DefaultFocusSet defaultFocusSet = this;
        synchronized (defaultFocusSet) {
            bl = this.m_foci.remove(entity);
        }
        if (bl && this.m_listener != null) {
            this.m_listener.focusChanged(new FocusEvent(this, 1, null, new Entity[]{entity}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Collection collection) {
        ArrayList arrayList = this.m_tmp;
        synchronized (arrayList) {
            Entity[] entityArray = this;
            synchronized (this) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!this.m_foci.remove(e) || this.m_listener == null) continue;
                    this.m_tmp.add(e);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (this.m_listener != null && this.m_tmp.size() > 0) {
                    entityArray = this.m_tmp.toArray(FocusEvent.EMPTY);
                    this.m_listener.focusChanged(new FocusEvent((FocusSet)this, 1, null, entityArray));
                }
                this.m_tmp.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Entity entity) {
        Entity[] entityArray = null;
        Entity[] entityArray2 = null;
        DefaultFocusSet defaultFocusSet = this;
        synchronized (defaultFocusSet) {
            if (this.m_foci.size() > 0 && this.m_listener != null) {
                entityArray2 = this.m_foci.toArray(FocusEvent.EMPTY);
            }
            this.m_foci.clear();
            if (this.m_foci.add(entity) && this.m_listener != null) {
                entityArray = new Entity[]{entity};
            }
        }
        if (entityArray != null || entityArray2 != null) {
            this.m_listener.focusChanged(new FocusEvent(this, 2, entityArray, entityArray2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Collection collection) {
        Entity[] entityArray = null;
        Entity[] entityArray2 = null;
        ArrayList arrayList = this.m_tmp;
        synchronized (arrayList) {
            DefaultFocusSet defaultFocusSet = this;
            synchronized (defaultFocusSet) {
                Object object;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object instanceof Entity) continue;
                    throw new IllegalArgumentException("All foci must be of type Entity");
                }
                if (this.m_listener != null && this.m_foci.size() > 0) {
                    entityArray2 = this.m_foci.toArray(FocusEvent.EMPTY);
                }
                this.m_foci.clear();
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object = (Entity)iterator.next();
                    if (!this.m_foci.add(object) || this.m_listener == null) continue;
                    this.m_tmp.add(object);
                }
            }
            if (this.m_listener != null && this.m_tmp.size() > 0) {
                entityArray = this.m_tmp.toArray(FocusEvent.EMPTY);
                this.m_tmp.clear();
            }
        }
        if (entityArray != null || entityArray2 != null) {
            this.m_listener.focusChanged(new FocusEvent(this, 2, entityArray, entityArray2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Entity[] entityArray = null;
        DefaultFocusSet defaultFocusSet = this;
        synchronized (defaultFocusSet) {
            if (this.m_listener != null && this.m_foci.size() > 0) {
                entityArray = this.m_foci.toArray(FocusEvent.EMPTY);
            }
            this.m_foci.clear();
        }
        if (entityArray != null) {
            this.m_listener.focusChanged(new FocusEvent(this, 2, null, entityArray));
        }
    }

    public synchronized Iterator iterator() {
        return this.m_foci.iterator();
    }

    public synchronized int size() {
        return this.m_foci.size();
    }

    public synchronized boolean contains(Entity entity) {
        return this.m_foci.contains(entity);
    }
}

