/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph;

import edu.berkeley.guir.prefuse.graph.AbstractGraph;
import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Node;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class DefaultGraph
extends AbstractGraph {
    protected LinkedHashSet m_nodes;
    protected LinkedHashSet m_edges;
    protected boolean m_directed = false;

    public DefaultGraph(Collection collection, boolean bl) {
        this(bl);
        this.m_nodes.addAll(collection);
        Iterator iterator = this.m_nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getEdges();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                if (edge.isDirected() != bl) {
                    throw new IllegalStateException("Directedness of edge and graph differ");
                }
                this.m_edges.add(edge);
            }
        }
    }

    public DefaultGraph(Collection collection) {
        this(collection, false);
    }

    public DefaultGraph() {
        this(false);
    }

    public DefaultGraph(boolean bl) {
        this.m_directed = bl;
        this.m_nodes = new LinkedHashSet();
        this.m_edges = new LinkedHashSet();
    }

    public void reinit(boolean bl) {
        this.m_nodes.clear();
        this.m_edges.clear();
        this.m_directed = bl;
    }

    public boolean addNode(Node node) {
        if (this.m_nodes.contains(node)) {
            return false;
        }
        this.m_nodes.add(node);
        this.fireNodeAdded(node);
        return true;
    }

    public boolean removeNode(Node node) {
        Entity entity;
        if (!this.m_nodes.contains(node)) {
            return false;
        }
        int n = node.getEdgeCount();
        for (int i = 0; i < n; ++i) {
            entity = node.removeEdge(0);
            if (!entity.isDirected()) {
                Node node2 = entity.getAdjacentNode(node);
                node2.removeNeighbor(node);
            }
            this.m_edges.remove(entity);
            this.fireEdgeRemoved((Edge)entity);
        }
        this.m_nodes.remove(node);
        if (this.m_directed) {
            Iterator iterator = this.m_nodes.iterator();
            while (iterator.hasNext()) {
                entity = (Node)iterator.next();
                int n2 = entity.getIndex(node);
                if (n2 <= -1) continue;
                Edge edge = entity.removeEdge(n2);
                this.m_edges.remove(edge);
                this.fireEdgeRemoved(edge);
            }
        }
        this.fireNodeRemoved(node);
        return true;
    }

    public boolean addEdge(Node node, Node node2) {
        return this.addEdge(new DefaultEdge(node, node2, this.m_directed));
    }

    public boolean addEdge(Edge edge) {
        if (this.m_directed ^ edge.isDirected()) {
            throw new IllegalStateException("Directedness of edge and graph differ");
        }
        Node node = edge.getFirstNode();
        Node node2 = edge.getSecondNode();
        if (this.m_edges.contains(edge) || node.isNeighbor(node2) || !this.m_directed && node2.isNeighbor(node)) {
            return false;
        }
        node.addEdge(edge);
        if (!this.m_directed) {
            node2.addEdge(edge);
        }
        this.m_edges.add(edge);
        this.fireEdgeAdded(edge);
        return true;
    }

    public boolean removeEdge(Edge edge) {
        Node node;
        if (this.m_directed ^ edge.isDirected()) {
            throw new IllegalStateException("Directedness of edge and graph differ");
        }
        Node node2 = edge.getFirstNode();
        if (!node2.isNeighbor(node = edge.getSecondNode()) || !this.m_directed && !node.isNeighbor(node2)) {
            return false;
        }
        node2.removeNeighbor(node);
        if (!this.m_directed) {
            node.removeNeighbor(node2);
        }
        this.m_edges.remove(edge);
        this.fireEdgeRemoved(edge);
        return true;
    }

    public boolean replaceNode(Node node, Node node2) {
        Entity entity;
        if (node2.getEdgeCount() > 0 || !this.contains(node) || this.contains(node2)) {
            return false;
        }
        Iterator iterator = node.getEdges();
        while (iterator.hasNext()) {
            entity = (Edge)iterator.next();
            if (entity.getFirstNode() == node) {
                entity.setFirstNode(node2);
            } else {
                entity.setSecondNode(node2);
            }
            node2.addEdge((Edge)entity);
        }
        node.removeAllNeighbors();
        if (this.m_directed) {
            iterator = this.m_nodes.iterator();
            while (iterator.hasNext()) {
                entity = (Node)iterator.next();
                int n = entity.getIndex(node);
                if (n <= -1) continue;
                Edge edge = entity.getEdge(n);
                if (edge.getFirstNode() == node) {
                    edge.setFirstNode(node2);
                    continue;
                }
                edge.setSecondNode(node2);
            }
        }
        this.fireNodeReplaced(node, node2);
        return true;
    }

    public boolean replaceEdge(Edge edge, Edge edge2) {
        boolean bl;
        boolean bl2 = bl = this.m_edges.contains(edge) && !this.m_edges.contains(edge2) && edge2.isDirected() == this.m_directed;
        if (!bl) {
            return false;
        }
        Node node = edge.getFirstNode();
        Node node2 = edge.getSecondNode();
        Node node3 = edge2.getFirstNode();
        Node node4 = edge2.getSecondNode();
        if (this.m_directed) {
            bl = node == node3 && node2 == node4;
        } else {
            boolean bl3 = bl = node == node3 && node2 == node4 || node == node4 && node2 == node3;
        }
        if (bl) {
            int n = node.getIndex(edge);
            node.removeEdge(n);
            node.addEdge(n, edge2);
            if (!this.m_directed) {
                n = node2.getIndex(edge);
                node2.removeEdge(n);
                node2.addEdge(n, edge2);
            }
            this.m_edges.remove(edge);
            this.fireEdgeReplaced(edge, edge2);
            return true;
        }
        return false;
    }

    public int getNodeCount() {
        return this.m_nodes.size();
    }

    public int getEdgeCount() {
        return this.m_edges.size();
    }

    public Iterator getNodes() {
        return this.m_nodes.iterator();
    }

    public Iterator getEdges() {
        return this.m_edges.iterator();
    }

    public boolean isDirected() {
        return this.m_directed;
    }

    public boolean contains(Node node) {
        return this.m_nodes.contains(node);
    }

    public boolean contains(Edge edge) {
        return this.m_edges.contains(edge);
    }
}

