/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph;

import edu.berkeley.guir.prefuse.collections.BreadthFirstTreeIterator;
import edu.berkeley.guir.prefuse.collections.TreeEdgeIterator;
import edu.berkeley.guir.prefuse.graph.AbstractGraph;
import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.GraphLib;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.Tree;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultTree
extends AbstractGraph
implements Tree {
    protected TreeNode m_root;

    public DefaultTree(TreeNode treeNode) {
        this.m_root = treeNode;
    }

    public DefaultTree() {
        this.m_root = null;
    }

    public boolean isDirected() {
        return false;
    }

    public void changeRoot(TreeNode treeNode) {
        Object object;
        if (!this.contains(treeNode)) {
            throw new IllegalArgumentException("The new root must already be in the tree");
        }
        TreeNode treeNode2 = treeNode;
        LinkedList<TreeNode> linkedList = new LinkedList<TreeNode>();
        for (object = treeNode2; object != null; object = object.getParent()) {
            linkedList.addFirst((TreeNode)object);
            if (object == this.m_root) break;
        }
        object = linkedList.iterator();
        TreeNode treeNode3 = (TreeNode)object.next();
        while (object.hasNext()) {
            TreeNode treeNode4 = (TreeNode)object.next();
            int n = treeNode3.getChildIndex(treeNode4);
            Edge edge = treeNode3.getChildEdge(n);
            treeNode3.removeAsChild(n);
            treeNode3.setParentEdge(edge);
            treeNode4.setAsChild(GraphLib.nearestIndex(treeNode4, treeNode3), treeNode3);
            treeNode3 = treeNode4;
        }
        this.m_root = treeNode;
    }

    public void setRoot(TreeNode treeNode) {
        if (treeNode != this.m_root) {
            TreeNode treeNode2 = this.m_root;
            this.m_root = treeNode;
            this.fireNodeRemoved(treeNode2);
            if (treeNode != null) {
                this.fireNodeAdded(treeNode);
            }
        }
    }

    public int getNodeCount() {
        return this.m_root == null ? 0 : this.m_root.getDescendantCount() + 1;
    }

    public int getEdgeCount() {
        return Math.max(0, this.getNodeCount() - 1);
    }

    public Iterator getNodes() {
        if (this.m_root == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new BreadthFirstTreeIterator(this.m_root);
    }

    public Iterator getEdges() {
        return new TreeEdgeIterator(this.getNodes());
    }

    public TreeNode getRoot() {
        return this.m_root;
    }

    public int getDepth(TreeNode treeNode) {
        TreeNode treeNode2;
        int n = 0;
        for (treeNode2 = treeNode; treeNode2 != this.m_root && treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            ++n;
        }
        return treeNode2 == null ? -1 : n;
    }

    public boolean addChild(Edge edge) {
        TreeNode treeNode;
        TreeNode treeNode2 = (TreeNode)edge.getFirstNode();
        TreeNode treeNode3 = (TreeNode)edge.getSecondNode();
        TreeNode treeNode4 = this.contains(treeNode2) ? treeNode2 : treeNode3;
        TreeNode treeNode5 = treeNode = treeNode4 == treeNode2 ? treeNode3 : treeNode2;
        if (edge.isDirected() || !this.contains(treeNode4) || this.contains(treeNode)) {
            return false;
        }
        treeNode4.addChild(edge);
        this.fireNodeAdded(treeNode);
        this.fireEdgeAdded(edge);
        return true;
    }

    public boolean addChild(Node node, Node node2) {
        return this.addChild(new DefaultEdge(node, node2));
    }

    public boolean removeChild(Edge edge) {
        TreeNode treeNode;
        TreeNode treeNode2;
        TreeNode treeNode3 = (TreeNode)edge.getFirstNode();
        TreeNode treeNode4 = (TreeNode)edge.getSecondNode();
        if (!this.contains(treeNode3) || !this.contains(treeNode4)) {
            return false;
        }
        int n = treeNode3.getChildIndex(edge);
        if (n > -1) {
            treeNode2 = treeNode3;
            treeNode = treeNode4;
        } else {
            n = treeNode4.getChildIndex(edge);
            if (n > -1) {
                treeNode2 = treeNode4;
                treeNode = treeNode3;
            } else {
                return false;
            }
        }
        treeNode2.removeChild(n);
        this.fireEdgeRemoved(edge);
        this.fireNodeRemoved(treeNode);
        return true;
    }

    public boolean addNode(Node node) {
        throw new UnsupportedOperationException("DefaultTree does not support addNode(). Use setRoot() or addChild() instead");
    }

    public boolean addEdge(Edge edge) {
        if (edge.isDirected()) {
            throw new IllegalStateException("Directedness of edge and graph differ");
        }
        Node node = edge.getFirstNode();
        Node node2 = edge.getSecondNode();
        if (!this.contains(node) || !this.contains(node2) || node.isNeighbor(node2) || node2.isNeighbor(node)) {
            return false;
        }
        node.addEdge(edge);
        node2.addEdge(edge);
        this.fireEdgeAdded(edge);
        return true;
    }

    public boolean removeNode(Node node) {
        if (!this.contains(node)) {
            return false;
        }
        if (node == this.m_root) {
            this.m_root = null;
        } else {
            ((TreeNode)node).getParent().removeChild((TreeNode)node);
        }
        this.fireNodeRemoved(node);
        return true;
    }

    public boolean removeEdge(Edge edge) {
        if (!this.contains(edge)) {
            return false;
        }
        TreeNode treeNode = (TreeNode)edge.getFirstNode();
        TreeNode treeNode2 = (TreeNode)edge.getSecondNode();
        if (!edge.isTreeEdge()) {
            treeNode.removeEdge(edge);
            treeNode2.removeEdge(edge);
            this.fireEdgeRemoved(edge);
        } else if (treeNode == this.m_root || treeNode2 == this.m_root) {
            TreeNode treeNode3 = this.m_root;
            this.m_root = null;
            this.fireNodeRemoved(treeNode3);
        } else {
            TreeNode treeNode4 = treeNode.getParent() == treeNode2 ? treeNode2 : treeNode;
            treeNode4.removeChildEdge(edge);
            this.fireNodeRemoved(edge.getAdjacentNode(treeNode4));
        }
        return true;
    }

    public boolean replaceNode(Node node, Node node2) {
        Edge edge;
        if (node2.getEdgeCount() > 0 || !this.contains(node) || this.contains(node2)) {
            return false;
        }
        if (!(node2 instanceof TreeNode)) {
            throw new IllegalArgumentException("Node next must be a TreeNode");
        }
        TreeNode treeNode = (TreeNode)node;
        TreeNode treeNode2 = (TreeNode)node2;
        Iterator iterator = treeNode.getEdges();
        while (iterator.hasNext()) {
            edge = (Edge)iterator.next();
            if (edge.getFirstNode() == treeNode) {
                edge.setFirstNode(treeNode2);
            } else {
                edge.setSecondNode(treeNode2);
            }
            treeNode2.addEdge(edge);
        }
        iterator = treeNode.getChildEdges();
        while (iterator.hasNext()) {
            edge = (Edge)iterator.next();
            treeNode2.addChild(edge);
        }
        ((TreeNode)node).removeAllAsChildren();
        node.removeAllNeighbors();
        if (treeNode == this.m_root) {
            this.setRoot(treeNode2);
        }
        this.fireNodeReplaced(node, node2);
        return true;
    }

    public boolean replaceEdge(Edge edge, Edge edge2) {
        boolean bl;
        boolean bl2 = bl = this.contains(edge) && !this.contains(edge2) && !edge2.isDirected();
        if (!bl) {
            return false;
        }
        Node node = edge.getFirstNode();
        Node node2 = edge.getSecondNode();
        Node node3 = edge2.getFirstNode();
        Node node4 = edge2.getSecondNode();
        boolean bl3 = bl = node == node3 && node2 == node4 || node == node4 && node2 == node3;
        if (bl) {
            int n = node.getIndex(edge);
            node.removeEdge(n);
            node.addEdge(n, edge2);
            n = node2.getIndex(edge);
            node2.removeEdge(n);
            node2.addEdge(n, edge2);
            this.fireEdgeReplaced(edge, edge2);
            return true;
        }
        return false;
    }

    public boolean contains(Node node) {
        if (node instanceof TreeNode) {
            for (TreeNode treeNode = (TreeNode)node; treeNode != null; treeNode = treeNode.getParent()) {
                if (treeNode == null || treeNode != this.m_root) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Edge edge) {
        Node node = edge.getFirstNode();
        return this.contains(node) && node.isIncidentEdge(edge);
    }
}

