/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph.external;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.graph.DefaultNode;
import edu.berkeley.guir.prefuse.graph.external.ExternalEntity;
import edu.berkeley.guir.prefuse.graph.external.ExternalNode;
import edu.berkeley.guir.prefuse.graph.external.ExternalTreeNode;
import edu.berkeley.guir.prefuse.graph.external.GraphLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class DatabaseLoader
extends GraphLoader {
    private final String[] m_columns;
    protected String m_neighborQuery;
    protected String m_childrenQuery;
    protected String m_parentQuery;
    private Connection m_db;
    private PreparedStatement m_ns;
    private PreparedStatement m_cs;
    private PreparedStatement m_ps;

    public DatabaseLoader(ItemRegistry itemRegistry, String[] stringArray) {
        super(itemRegistry, stringArray[0]);
        this.m_columns = stringArray;
    }

    public String[] getColumns() {
        return this.m_columns;
    }

    public void connect(String string, String string2, String string3, String string4) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class.forName(string).newInstance();
        this.m_db = DriverManager.getConnection(string2, string3, string4);
        if (this.m_neighborQuery != null) {
            this.m_ns = this.prepare(this.m_neighborQuery);
        }
        if (this.m_childrenQuery != null) {
            this.m_cs = this.prepare(this.m_childrenQuery);
        }
        if (this.m_parentQuery != null) {
            this.m_ps = this.prepare(this.m_parentQuery);
        }
    }

    public Connection getConnection() {
        return this.m_db;
    }

    private PreparedStatement prepare(String string) throws SQLException {
        if (string == null) {
            throw new IllegalArgumentException("Input query must be non-null");
        }
        if (this.m_db == null) {
            throw new IllegalStateException("Connection to database not yet established! Make sure connect() is called first.");
        }
        return this.m_db.prepareStatement(string);
    }

    public void setNeighborQuery(String string) throws SQLException {
        if (this.m_db != null) {
            this.m_ns = this.prepare(string);
        }
        this.m_neighborQuery = string;
    }

    public String getNeighborQuery() {
        return this.m_neighborQuery;
    }

    public void setChildrenQuery(String string) throws SQLException {
        if (this.m_db != null) {
            this.m_cs = this.prepare(string);
        }
        this.m_childrenQuery = string;
    }

    public String getChildrenQuery() {
        return this.m_childrenQuery;
    }

    public void setParentQuery(String string) throws SQLException {
        if (this.m_db != null) {
            this.m_ps = this.prepare(string);
        }
        this.m_parentQuery = string;
    }

    public String getParentQuery() {
        return this.m_parentQuery;
    }

    protected abstract void prepareNeighborQuery(PreparedStatement var1, ExternalNode var2);

    protected abstract void prepareChildrenQuery(PreparedStatement var1, ExternalTreeNode var2);

    protected abstract void prepareParentQuery(PreparedStatement var1, ExternalTreeNode var2);

    protected void getNeighbors(ExternalNode externalNode) {
        this.prepareNeighborQuery(this.m_ns, externalNode);
        this.loadNodes(0, this.m_ns, externalNode);
    }

    protected void getChildren(ExternalTreeNode externalTreeNode) {
        this.prepareChildrenQuery(this.m_cs, externalTreeNode);
        this.loadNodes(1, this.m_cs, externalTreeNode);
    }

    protected void getParent(ExternalTreeNode externalTreeNode) {
        this.prepareParentQuery(this.m_ps, externalTreeNode);
        this.loadNodes(2, this.m_ps, externalTreeNode);
    }

    private void loadNodes(int n, PreparedStatement preparedStatement, ExternalEntity externalEntity) {
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.loadNode(n, resultSet, externalEntity);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public ExternalEntity loadNode(int n, ResultSet resultSet, ExternalEntity externalEntity) throws SQLException {
        DefaultNode defaultNode = n == 0 ? new ExternalNode() : new ExternalTreeNode();
        for (int i = 0; i < this.m_columns.length; ++i) {
            String string = resultSet.getString(this.m_columns[i]);
            if (string != null) {
                string = string.replaceAll("\r", "");
            }
            defaultNode.setAttribute(this.m_columns[i], string);
        }
        super.foundNode(n, externalEntity, (ExternalEntity)((Object)defaultNode), null);
        return defaultNode;
    }
}

