/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph.external;

import edu.berkeley.guir.prefuse.graph.DefaultNode;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.external.ExternalEntity;
import edu.berkeley.guir.prefuse.graph.external.ExternalTreeNode;
import edu.berkeley.guir.prefuse.graph.external.GraphLoader;
import java.util.Iterator;

public class ExternalNode
extends DefaultNode
implements ExternalEntity {
    protected GraphLoader m_loader;
    protected boolean m_loaded = false;
    protected boolean m_loadStarted = false;

    protected void checkLoadedStatus() {
        this.touch();
        if (!this.m_loadStarted) {
            this.m_loadStarted = true;
            this.m_loader.loadNeighbors(this);
        }
    }

    public void setLoader(GraphLoader graphLoader) {
        this.m_loader = graphLoader;
    }

    void setNeighborsLoaded(boolean bl) {
        this.m_loaded = bl;
        this.m_loadStarted = bl;
    }

    public boolean isNeighborsLoaded() {
        return this.m_loaded;
    }

    public void touch() {
        this.m_loader.touch(this);
    }

    public void unload() {
        Iterator iterator = this.m_edges.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            Node node = edge.getAdjacentNode(this);
            node.removeEdge(edge);
            if (node instanceof ExternalNode) {
                ((ExternalNode)node).setNeighborsLoaded(false);
                continue;
            }
            if (!(node instanceof ExternalTreeNode)) continue;
            ((ExternalTreeNode)node).setParentLoaded(false);
            ((ExternalTreeNode)node).setChildrenLoaded(false);
        }
        this.m_edges.clear();
    }

    public boolean addEdge(Edge edge) {
        this.touch();
        return super.addEdge(edge);
    }

    public boolean addEdge(int n, Edge edge) {
        this.touch();
        return super.addEdge(n, edge);
    }

    public Edge getEdge(int n) {
        this.checkLoadedStatus();
        return super.getEdge(n);
    }

    public Edge getEdge(Node node) {
        this.checkLoadedStatus();
        return super.getEdge(node);
    }

    public int getEdgeCount() {
        this.touch();
        return super.getEdgeCount();
    }

    public Iterator getEdges() {
        this.checkLoadedStatus();
        return super.getEdges();
    }

    public int getIndex(Edge edge) {
        this.touch();
        return super.getIndex(edge);
    }

    public int getIndex(Node node) {
        this.touch();
        return super.getIndex(node);
    }

    public Node getNeighbor(int n) {
        this.checkLoadedStatus();
        return super.getNeighbor(n);
    }

    public Iterator getNeighbors() {
        this.checkLoadedStatus();
        return super.getNeighbors();
    }

    public boolean isIncidentEdge(Edge edge) {
        this.touch();
        return super.isIncidentEdge(edge);
    }

    public boolean isNeighbor(Node node) {
        this.touch();
        return super.isNeighbor(node);
    }

    public boolean removeEdge(Edge edge) {
        this.touch();
        return super.removeEdge(edge);
    }

    public Edge removeEdge(int n) {
        this.touch();
        return super.removeEdge(n);
    }

    public Node removeNeighbor(int n) {
        this.touch();
        return super.removeNeighbor(n);
    }

    public boolean removeNeighbor(Node node) {
        this.touch();
        return super.removeNeighbor(node);
    }
}

