/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph.external;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.graph.external.ExternalEntity;
import edu.berkeley.guir.prefuse.graph.external.ExternalNode;
import edu.berkeley.guir.prefuse.graph.external.ExternalTreeNode;
import edu.berkeley.guir.prefuse.graph.external.GraphLoader;
import java.io.File;
import java.io.IOException;

public class FileSystemLoader
extends GraphLoader {
    public FileSystemLoader(ItemRegistry itemRegistry) {
        super(itemRegistry, "filename");
    }

    protected void getNeighbors(ExternalNode externalNode) {
        File[] fileArray;
        String string = externalNode.getAttribute("filename");
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null) {
            this.loadNode(0, externalNode, file2);
        }
        if ((fileArray = file.listFiles()) == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.loadNode(0, externalNode, fileArray[i]);
        }
    }

    protected void getChildren(ExternalTreeNode externalTreeNode) {
        String string = externalTreeNode.getAttribute("filename");
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.loadNode(1, externalTreeNode, fileArray[i]);
        }
    }

    protected void getParent(ExternalTreeNode externalTreeNode) {
        String string = externalTreeNode.getAttribute("filename");
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null) {
            this.loadNode(2, externalTreeNode, file2);
        }
    }

    public ExternalEntity loadNode(int n, ExternalEntity externalEntity, File file) {
        ExternalEntity externalEntity2 = null;
        try {
            file = file.getCanonicalFile();
            String string = file.getName();
            if (this.m_cache.containsKey(string)) {
                externalEntity2 = (ExternalEntity)this.m_cache.get(string);
            } else {
                externalEntity2 = n == 0 ? new ExternalNode() : new ExternalTreeNode();
                String string2 = file.getName();
                externalEntity2.setAttribute("label", string2.equals("") ? file.getPath() : string2);
                externalEntity2.setAttribute("filename", file.getPath());
                externalEntity2.setAttribute("size", String.valueOf(file.length()));
                externalEntity2.setAttribute("modified", String.valueOf(file.lastModified()));
            }
            this.foundNode(n, externalEntity, externalEntity2, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return externalEntity2;
    }
}

