/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.graph.io;

import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.berkeley.guir.prefuse.graph.io.AbstractGraphWriter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class XMLGraphWriter
extends AbstractGraphWriter {
    public static final String NODE = "node";
    public static final String EDGE = "edge";
    public static final String ATT = "att";
    public static final String ID = "id";
    public static final String LABEL = "label";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String WEIGHT = "weight";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String LIST = "list";
    public static final String GRAPH = "graph";
    public static final String DIRECTED = "directed";
    public static final String[] NODE_ATTR = new String[]{"id", "label", "weight"};
    public static final String[] EDGE_ATTR = new String[]{"label", "weight"};

    public void writeGraph(Graph graph, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(outputStream));
        this.assignIDs(graph);
        this.printGraph(printWriter, graph);
        printWriter.flush();
    }

    protected void assignIDs(Graph graph) {
        Set set = this.initializeIDs(graph);
        int n = 0;
        Iterator iterator = graph.getNodes();
        while (iterator.hasNext()) {
            String string;
            Node node = (Node)iterator.next();
            if (node.getAttribute(ID) != null) continue;
            while (set.contains(string = String.valueOf(++n))) {
            }
            node.setAttribute(ID, string);
        }
    }

    private Set initializeIDs(Graph graph) {
        HashSet<String> hashSet = new HashSet<String>(graph.getNodeCount() / 2);
        Iterator iterator = graph.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string = node.getAttribute(ID);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private void printGraph(PrintWriter printWriter, Graph graph) {
        Object object;
        int n = graph.isDirected() ? 1 : 0;
        printWriter.println("<!-- prefuse graph writer :: " + new Date() + " -->");
        printWriter.println("<graph directed=\"" + n + "\">");
        printWriter.println("  <!-- nodes -->");
        Iterator iterator = graph.getNodes();
        while (iterator.hasNext()) {
            object = (Node)iterator.next();
            this.printNode(printWriter, (Node)object);
        }
        printWriter.println("  <!-- edges -->");
        object = graph.getEdges();
        while (object.hasNext()) {
            Edge edge = (Edge)object.next();
            this.printEdge(printWriter, edge);
        }
        printWriter.println("</graph>");
    }

    private void printNode(PrintWriter printWriter, Node node) {
        Object object;
        printWriter.print("  <node");
        for (int i = 0; i < NODE_ATTR.length; ++i) {
            object = NODE_ATTR[i];
            String string = node.getAttribute((String)object);
            if (string == null) continue;
            printWriter.print(" " + (String)object + "=\"" + string + "\"");
        }
        printWriter.print(">");
        Map map = node.getAttributes();
        object = map.keySet().iterator();
        boolean bl = false;
        while (object.hasNext()) {
            String string = (String)object.next();
            if (this.contains(NODE_ATTR, string)) continue;
            String string2 = (String)map.get(string);
            if (!bl) {
                printWriter.println();
                bl = true;
            }
            this.printAttr(printWriter, string, string2);
        }
        printWriter.println("  </node>");
    }

    private void printEdge(PrintWriter printWriter, Edge edge) {
        Object object;
        String string = edge.getFirstNode().getAttribute(ID);
        String string2 = edge.getSecondNode().getAttribute(ID);
        printWriter.print("  <edge");
        printWriter.print(" source=\"" + string + "\"");
        printWriter.print(" target=\"" + string2 + "\"");
        for (int i = 0; i < EDGE_ATTR.length; ++i) {
            object = EDGE_ATTR[i];
            String string3 = edge.getAttribute((String)object);
            if (string3 == null) continue;
            printWriter.print(" " + (String)object + "=\"" + string3 + "\"");
        }
        printWriter.print(">");
        Map map = edge.getAttributes();
        object = map.keySet().iterator();
        boolean bl = false;
        while (object.hasNext()) {
            String string4 = (String)object.next();
            if (this.contains(EDGE_ATTR, string4)) continue;
            String string5 = (String)map.get(string4);
            if (!bl) {
                printWriter.println();
                bl = true;
            }
            this.printAttr(printWriter, string4, string5);
        }
        printWriter.println("  </edge>");
    }

    private void printAttr(PrintWriter printWriter, String string, String string2) {
        printWriter.println("    <att name=\"" + string + "\" " + VALUE + "=\"" + string2 + "\"/>");
    }

    private boolean contains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

