/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.render;

import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.graph.Entity;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ImageFactory {
    private int m_imageCacheSize = 3000;
    private int m_maxImageWidth = 100;
    private int m_maxImageHeight = 100;
    private boolean m_asynch = true;
    private Map imageCache = new LinkedHashMap((int)((float)this.m_imageCacheSize + 1.3333334f), 0.75f, true){

        public boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > ImageFactory.this.m_imageCacheSize;
        }
    };
    private Map loadMap = new HashMap(50);
    private Map loadingMap = new HashMap(50);
    private Set loadingSet = new HashSet(50);
    private final Component component = new Component(){};
    private final MediaTracker tracker = new MediaTracker(this.component);
    private int nextTrackerID = 0;
    static /* synthetic */ Class class$edu$berkeley$guir$prefuse$render$ImageFactory;

    public ImageFactory() {
        this(-1, -1);
    }

    public ImageFactory(int n, int n2) {
        this.setMaxImageDimensions(n, n2);
    }

    public void setMaxImageDimensions(int n, int n2) {
        this.m_maxImageWidth = n;
        this.m_maxImageHeight = n2;
    }

    public void setImageCacheSize(int n) {
        this.m_imageCacheSize = n;
    }

    public Image getImage(String string) {
        Image image = (Image)this.imageCache.get(string);
        if (image == null && !this.loadMap.containsKey(string)) {
            URL uRL = this.getImageURL(string);
            if (uRL == null) {
                System.err.println("Null image: " + string);
                return null;
            }
            image = Toolkit.getDefaultToolkit().createImage(uRL);
            if (!this.m_asynch) {
                this.waitForImage(image);
                this.addImage(string, image);
            } else {
                int n = ++this.nextTrackerID;
                this.tracker.addImage(image, n);
                this.loadMap.put(string, new LoadMapEntry(n, image));
            }
        } else if (image == null && this.loadMap.containsKey(string)) {
            LoadMapEntry loadMapEntry = (LoadMapEntry)this.loadMap.get(string);
            if (this.tracker.checkID(loadMapEntry.id, true)) {
                this.addImage(string, loadMapEntry.image);
                this.loadMap.remove(string);
                this.tracker.removeImage(loadMapEntry.image, loadMapEntry.id);
            }
        } else {
            return image;
        }
        return (Image)this.imageCache.get(string);
    }

    public Image addImage(String string, Image image) {
        if (this.m_maxImageWidth > -1 || this.m_maxImageHeight > -1) {
            image = this.getScaledImage(image);
            image.getWidth(null);
        }
        this.imageCache.put(string, image);
        return image;
    }

    protected void waitForImage(Image image) {
        int n = ++this.nextTrackerID;
        this.tracker.addImage(image, n);
        try {
            this.tracker.waitForID(n, 0L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.tracker.removeImage(image, n);
    }

    protected URL getImageURL(String string) {
        URL uRL = null;
        if (string.startsWith("http:/") || string.startsWith("ftp:/") || string.startsWith("file:/")) {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            uRL = (class$edu$berkeley$guir$prefuse$render$ImageFactory == null ? (class$edu$berkeley$guir$prefuse$render$ImageFactory = ImageFactory.class$("edu.berkeley.guir.prefuse.render.ImageFactory")) : class$edu$berkeley$guir$prefuse$render$ImageFactory).getResource(string);
            if (uRL == null && !string.startsWith("/")) {
                uRL = (class$edu$berkeley$guir$prefuse$render$ImageFactory == null ? (class$edu$berkeley$guir$prefuse$render$ImageFactory = ImageFactory.class$("edu.berkeley.guir.prefuse.render.ImageFactory")) : class$edu$berkeley$guir$prefuse$render$ImageFactory).getResource("/" + string);
            }
        }
        return uRL;
    }

    protected Image getScaledImage(Image image) {
        int n;
        int n2 = image.getWidth(null) - this.m_maxImageWidth;
        if (n2 > (n = image.getHeight(null) - this.m_maxImageHeight) && n2 > 0 && this.m_maxImageWidth > -1) {
            Image image2 = image.getScaledInstance(this.m_maxImageWidth, -1, 4);
            image.flush();
            return image2;
        }
        if (n > 0 && this.m_maxImageHeight > -1) {
            Image image3 = image.getScaledInstance(-1, this.m_maxImageHeight, 4);
            image.flush();
            return image3;
        }
        return image;
    }

    public void preloadImages(Iterator iterator, String string) {
        boolean bl = this.m_asynch;
        this.m_asynch = false;
        String string2 = null;
        while (iterator.hasNext() && this.imageCache.size() <= this.m_imageCacheSize) {
            Object e = iterator.next();
            if (e instanceof Entity) {
                string2 = ((Entity)e).getAttribute(string);
            } else if (e instanceof VisualItem) {
                string2 = ((VisualItem)e).getAttribute(string);
            }
            if (string2 == null) continue;
            this.getImage(string2);
        }
        this.m_asynch = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LoadMapEntry {
        public int id;
        public Image image;

        public LoadMapEntry(int n, Image image) {
            this.id = n;
            this.image = image;
        }
    }
}

