/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.render;

import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.render.ImageFactory;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.ShapeRenderer;
import edu.berkeley.guir.prefuse.util.FontLib;
import edu.berkeley.guir.prefuse.util.StringAbbreviator;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class TextImageItemRenderer
extends ShapeRenderer {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_CENTER = 2;
    public static final int ALIGNMENT_BOTTOM = 1;
    public static final int ALIGNMENT_TOP = 0;
    protected ImageFactory m_images = new ImageFactory();
    protected String m_labelName = "label";
    protected String m_imageName = "image";
    protected int m_arcWidth;
    protected int m_arcHeight;
    protected int m_xAlign = 2;
    protected int m_yAlign = 2;
    protected int m_horizBorder = 3;
    protected int m_vertBorder = 0;
    protected int m_imageMargin = 4;
    protected int m_maxTextWidth = -1;
    protected int m_abbrevType = 3;
    protected StringAbbreviator m_abbrev = StringAbbreviator.getInstance();
    protected double m_imageSize = 1.0;
    protected boolean m_showImages = true;
    protected Font m_font = new Font("SansSerif", 0, 10);
    protected RectangularShape m_imageBox = new Rectangle2D.Float();
    protected Point2D m_tmpPoint = new Point2D.Double();
    protected AffineTransform m_transform = new AffineTransform();

    public void setRoundedCorner(int n, int n2) {
        if (!(n != 0 && n2 != 0 || this.m_imageBox instanceof Rectangle2D)) {
            this.m_imageBox = new Rectangle2D.Float();
        } else {
            if (!(this.m_imageBox instanceof RoundRectangle2D)) {
                this.m_imageBox = new RoundRectangle2D.Float();
            }
            ((RoundRectangle2D)this.m_imageBox).setRoundRect(0.0, 0.0, 10.0, 10.0, n, n2);
        }
        this.m_arcWidth = n;
        this.m_arcHeight = n2;
    }

    public String getTextAttributeName() {
        return this.m_labelName;
    }

    public void setTextAttributeName(String string) {
        this.m_labelName = string;
    }

    public void setMaxTextWidth(int n) {
        this.m_maxTextWidth = n;
    }

    public void setAbbrevType(int n) {
        this.m_abbrevType = n;
    }

    protected String getText(VisualItem visualItem) {
        String string = visualItem.getAttribute(this.m_labelName);
        if (this.m_maxTextWidth > -1) {
            FontMetrics fontMetrics;
            Font font = visualItem.getFont();
            if (font == null) {
                font = this.m_font;
            }
            if ((fontMetrics = Renderer.DEFAULT_GRAPHICS.getFontMetrics(font)).stringWidth(string) > this.m_maxTextWidth) {
                string = this.m_abbrev.abbreviate(string, this.m_abbrevType, fontMetrics, this.m_maxTextWidth);
            }
        }
        return string;
    }

    public void setImageSize(double d) {
        this.m_imageSize = d;
    }

    public void setMaxImageDimensions(int n, int n2) {
        this.m_images.setMaxImageDimensions(n, n2);
    }

    public String getImageAttributeName() {
        return this.m_imageName;
    }

    public void setImageAttributeName(String string) {
        this.m_imageName = string;
    }

    protected String getImageLocation(VisualItem visualItem) {
        return visualItem.getAttribute(this.m_imageName);
    }

    protected Image getImage(VisualItem visualItem) {
        if (!this.m_showImages) {
            return null;
        }
        String string = this.getImageLocation(visualItem);
        return string == null ? null : this.m_images.getImage(string);
    }

    protected Shape getRawShape(VisualItem visualItem) {
        String string;
        double d = visualItem.getSize();
        Image image = this.getImage(visualItem);
        double d2 = d * this.m_imageSize;
        double d3 = image == null ? 0.0 : d2 * (double)image.getHeight(null);
        double d4 = image == null ? 0.0 : d2 * (double)image.getWidth(null);
        this.m_font = visualItem.getFont();
        if (d != 1.0) {
            this.m_font = FontLib.getFont(this.m_font.getName(), this.m_font.getStyle(), d * (double)this.m_font.getSize());
        }
        if ((string = this.getText(visualItem)) == null) {
            string = "";
        }
        FontMetrics fontMetrics = Renderer.DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth(string) + 2;
        double d5 = (double)n2 + d4 + d * (double)(2 * this.m_horizBorder + (n2 > 0 && d4 > 0.0 ? this.m_imageMargin : 0));
        double d6 = Math.max((double)n, d3) + d * 2.0 * (double)this.m_vertBorder;
        TextImageItemRenderer.getAlignedPoint(this.m_tmpPoint, visualItem, d5, d6, this.m_xAlign, this.m_yAlign);
        if (this.m_imageBox instanceof RoundRectangle2D) {
            ((RoundRectangle2D)this.m_imageBox).setRoundRect(this.m_tmpPoint.getX(), this.m_tmpPoint.getY(), d5, d6, d * (double)this.m_arcWidth, d * (double)this.m_arcHeight);
        } else {
            this.m_imageBox.setFrame(this.m_tmpPoint.getX(), this.m_tmpPoint.getY(), d5, d6);
        }
        return this.m_imageBox;
    }

    protected static void getAlignedPoint(Point2D point2D, VisualItem visualItem, double d, double d2, int n, int n2) {
        double d3 = visualItem.getX();
        double d4 = visualItem.getY();
        if (n == 2) {
            d3 -= d / 2.0;
        } else if (n == 1) {
            d3 -= d;
        }
        if (n2 == 2) {
            d4 -= d2 / 2.0;
        } else if (n2 == 1) {
            d4 -= d2;
        }
        point2D.setLocation(d3, d4);
    }

    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        double d;
        Object object;
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            return;
        }
        Paint paint = visualItem.getColor();
        Paint paint2 = visualItem.getFillColor();
        int n = this.getRenderType(visualItem);
        if (n == 2 || n == 3) {
            graphics2D.setPaint(paint2);
            graphics2D.fill(shape);
        }
        String string = this.getText(visualItem);
        Image image = this.getImage(visualItem);
        if (string == null && image == null) {
            return;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d2 = visualItem.getSize();
        double d3 = rectangle2D.getMinX() + d2 * (double)this.m_horizBorder;
        if (image != null) {
            int n2;
            object = graphics2D.getComposite();
            if (paint2 instanceof Color && (n2 = ((Color)paint2).getAlpha()) < 255) {
                AlphaComposite alphaComposite = AlphaComposite.getInstance(10, (float)n2 / 255.0f);
                graphics2D.setComposite(alphaComposite);
            }
            d = this.m_imageSize * d2;
            double d4 = d * (double)image.getWidth(null);
            double d5 = d * (double)image.getHeight(null);
            double d6 = rectangle2D.getMinY() + (rectangle2D.getHeight() - d5) / 2.0;
            this.m_transform.setTransform(d, 0.0, 0.0, d, d3, d6);
            graphics2D.drawImage(image, this.m_transform, null);
            d3 += d4 + (string != null && d4 > 0.0 ? d2 * (double)this.m_imageMargin : 0.0);
            graphics2D.setComposite((Composite)object);
        }
        if (string != null) {
            graphics2D.setPaint(paint);
            graphics2D.setFont(this.m_font);
            object = Renderer.DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
            d = rectangle2D.getY() + (rectangle2D.getHeight() - (double)((FontMetrics)object).getHeight()) / 2.0 + (double)((FontMetrics)object).getAscent();
            graphics2D.drawString(string, (float)d3 + 1.0f, (float)d);
        }
        if (n == 1 || n == 3) {
            object = graphics2D.getStroke();
            BasicStroke basicStroke = this.getStroke(visualItem);
            if (basicStroke != null) {
                graphics2D.setStroke(basicStroke);
            }
            graphics2D.setPaint(paint);
            graphics2D.draw(shape);
            graphics2D.setStroke((Stroke)object);
        }
    }

    public ImageFactory getImageFactory() {
        return this.m_images;
    }

    public void setImageFactory(ImageFactory imageFactory) {
        this.m_images = imageFactory;
    }

    public int getHorizontalAlignment() {
        return this.m_xAlign;
    }

    public int getVerticalAlignment() {
        return this.m_yAlign;
    }

    public void setHorizontalAlignment(int n) {
        this.m_xAlign = n;
    }

    public void setVerticalAlignment(int n) {
        this.m_yAlign = n;
    }

    public int getHorizontalPadding() {
        return this.m_horizBorder;
    }

    public void setHorizontalPadding(int n) {
        this.m_horizBorder = n;
    }

    public int getVerticalPadding() {
        return this.m_vertBorder;
    }

    public void setVerticalPadding(int n) {
        this.m_vertBorder = n;
    }

    public int getImageSpacing() {
        return this.m_imageMargin;
    }

    public void setImageSpacing(int n) {
        this.m_imageMargin = n;
    }

    public boolean isShowImages() {
        return this.m_showImages;
    }

    public void setShowImages(boolean bl) {
        this.m_showImages = bl;
    }
}

