/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Comparator;
import java.util.StringTokenizer;

public abstract class ArrayLib {
    public static final int MERGE_THRESHOLD = 1000;

    public static final int binarySearch(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n3 / 2;
        while (n2 < n3) {
            if (nArray[n4] == n) {
                return n4;
            }
            if (nArray[n4] < n) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * (n4 + 1);
    }

    public static final int binarySearch(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = n4 / 2;
        while (n3 < n4) {
            if (nArray[n5] == n) {
                return n5;
            }
            if (nArray[n5] < n) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1 * (n5 + 1);
    }

    public static final int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = n4 + (n5 - n4) / 2;
        while (n4 < n5) {
            if (nArray[n6] == n) {
                return n6;
            }
            if (nArray[n6] < n) {
                n4 = n6 + 1;
            } else {
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
        }
        return -1 * (n6 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object) {
        int n = 0;
        int n2 = objectArray.length;
        int n3 = n2 / 2;
        while (n < n2) {
            int n4 = ((Comparable)objectArray[n3]).compareTo(object);
            if (n4 == 0) {
                return n3;
            }
            if (n4 < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1 * (n3 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = n3 / 2;
        while (n2 < n3) {
            int n5 = ((Comparable)objectArray[n4]).compareTo(object);
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * (n4 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = n3 + (n4 - n3) / 2;
        while (n3 < n4) {
            int n6 = ((Comparable)objectArray[n5]).compareTo(object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1 * (n5 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator comparator) {
        int n = 0;
        int n2 = objectArray.length;
        int n3 = n2 / 2;
        while (n < n2) {
            int n4 = comparator.compare(objectArray[n3], object);
            if (n4 == 0) {
                return n3;
            }
            if (n4 < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        return -1 * (n3 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator comparator, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = n3 / 2;
        while (n2 < n3) {
            int n5 = comparator.compare(objectArray[n4], object);
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * (n4 + 1);
    }

    public static final int binarySearch(Object[] objectArray, Object object, Comparator comparator, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = n3 + (n4 - n3) / 2;
        while (n3 < n4) {
            int n6 = comparator.compare(objectArray[n5], object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1 * (n5 + 1);
    }

    public static final int find(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int find(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int find(int[] nArray, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int[] resize(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static final float[] resize(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    public static final double[] resize(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static final Object[] resize(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static final int[] trim(int[] nArray, int n) {
        if (nArray.length == n) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static final float[] trim(float[] fArray, int n) {
        if (fArray.length == n) {
            return fArray;
        }
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, n);
        return fArray2;
    }

    public static final double[] trim(double[] dArray, int n) {
        if (dArray.length == n) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    public static final void sort(int[] nArray, double[] dArray) {
        ArrayLib.mergesort(nArray, dArray, 0, nArray.length - 1);
    }

    public static final void sort(int[] nArray, double[] dArray, int n) {
        ArrayLib.mergesort(nArray, dArray, 0, n - 1);
    }

    public static final void sort(int[] nArray, double[] dArray, int n, int n2) {
        ArrayLib.mergesort(nArray, dArray, n, n2 - 1);
    }

    public static final void insertionsort(int[] nArray, double[] dArray, int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3 = nArray[i];
            double d = dArray[i];
            for (int j = i - 1; j >= n && nArray[j] > n3; --j) {
                nArray[j + 1] = nArray[j];
                dArray[j + 1] = dArray[j];
            }
            nArray[j + 1] = n3;
            dArray[j + 1] = d;
        }
    }

    public static final void mergesort(int[] nArray, double[] dArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        if (n2 - n + 1 < 1000) {
            ArrayLib.insertionsort(nArray, dArray, n, n2);
        } else {
            int n3 = (n + n2) / 2;
            ArrayLib.mergesort(nArray, dArray, n, n3);
            ArrayLib.mergesort(nArray, dArray, n3 + 1, n2);
            ArrayLib.merge(nArray, dArray, n, n3, n2);
        }
    }

    public static final void merge(int[] nArray, double[] dArray, int n, int n2, int n3) {
        int[] nArray2 = new int[n3 - n + 1];
        double[] dArray2 = new double[n3 - n + 1];
        int n4 = n;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 <= n2 && n5 <= n3) {
            if (nArray[n4] < nArray[n5]) {
                dArray2[n6] = dArray[n4];
                nArray2[n6] = nArray[n4++];
            } else {
                dArray2[n6] = dArray[n5];
                nArray2[n6] = nArray[n5++];
            }
            ++n6;
        }
        while (n4 <= n2) {
            dArray2[n6] = dArray[n4];
            nArray2[n6] = nArray[n4];
            ++n4;
            ++n6;
        }
        while (n5 <= n3) {
            dArray2[n6] = dArray[n5];
            nArray2[n6] = nArray[n5];
            ++n5;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n6 < nArray2.length) {
            dArray[n4] = dArray2[n6];
            nArray[n4] = nArray2[n6];
            ++n6;
            ++n4;
        }
    }

    public static final void quicksort(int[] nArray, double[] dArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        int n3 = ArrayLib.partition(nArray, dArray, n, n2);
        ArrayLib.quicksort(nArray, dArray, n, n3);
        ArrayLib.quicksort(nArray, dArray, n3 + 1, n2);
    }

    private static final int partition(int[] nArray, double[] dArray, int n, int n2) {
        int n3 = nArray[n];
        int n4 = n;
        int n5 = n2;
        while (true) {
            if (nArray[n5] > n3) {
                --n5;
                continue;
            }
            while (nArray[n4] < n3) {
                ++n4;
            }
            if (n4 >= n5) break;
            int n6 = nArray[n4];
            double d = dArray[n4];
            nArray[n4] = nArray[n5];
            dArray[n4] = dArray[n5];
            nArray[n5] = n6;
            dArray[n5] = d;
        }
        return n5;
    }

    public static final void sort(int[] nArray, int[] nArray2) {
        ArrayLib.mergesort(nArray, nArray2, 0, nArray.length - 1);
    }

    public static final void sort(int[] nArray, int[] nArray2, int n) {
        ArrayLib.mergesort(nArray, nArray2, 0, n - 1);
    }

    public static final void sort(int[] nArray, int[] nArray2, int n, int n2) {
        ArrayLib.mergesort(nArray, nArray2, n, n2 - 1);
    }

    public static final void insertionsort(int[] nArray, int[] nArray2, int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3 = nArray[i];
            int n4 = nArray2[i];
            for (int j = i - 1; j >= n && nArray[j] > n3; --j) {
                nArray[j + 1] = nArray[j];
                nArray2[j + 1] = nArray2[j];
            }
            nArray[j + 1] = n3;
            nArray2[j + 1] = n4;
        }
    }

    public static final void mergesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n >= n2) {
            return;
        }
        if (n2 - n + 1 < 1000) {
            ArrayLib.insertionsort(nArray, nArray2, n, n2);
        } else {
            int n3 = (n + n2) / 2;
            ArrayLib.mergesort(nArray, nArray2, n, n3);
            ArrayLib.mergesort(nArray, nArray2, n3 + 1, n2);
            ArrayLib.merge(nArray, nArray2, n, n3, n2);
        }
    }

    public static final void merge(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int[] nArray3 = new int[n3 - n + 1];
        int[] nArray4 = new int[n3 - n + 1];
        int n4 = n;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 <= n2 && n5 <= n3) {
            if (nArray[n4] < nArray[n5]) {
                nArray4[n6] = nArray2[n4];
                nArray3[n6] = nArray[n4++];
            } else {
                nArray4[n6] = nArray2[n5];
                nArray3[n6] = nArray[n5++];
            }
            ++n6;
        }
        while (n4 <= n2) {
            nArray4[n6] = nArray2[n4];
            nArray3[n6] = nArray[n4];
            ++n4;
            ++n6;
        }
        while (n5 <= n3) {
            nArray4[n6] = nArray2[n5];
            nArray3[n6] = nArray[n5];
            ++n5;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n6 < nArray3.length) {
            nArray2[n4] = nArray4[n6];
            nArray[n4] = nArray3[n6];
            ++n6;
            ++n4;
        }
    }

    public static final void quicksort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n >= n2) {
            return;
        }
        int n3 = ArrayLib.partition(nArray, nArray2, n, n2);
        ArrayLib.quicksort(nArray, nArray2, n, n3);
        ArrayLib.quicksort(nArray, nArray2, n3 + 1, n2);
    }

    private static final int partition(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray[n];
        int n4 = n;
        int n5 = n2;
        while (true) {
            if (nArray[n5] > n3) {
                --n5;
                continue;
            }
            while (nArray[n4] < n3) {
                ++n4;
            }
            if (n4 >= n5) break;
            int n6 = nArray[n4];
            int n7 = nArray2[n4];
            nArray[n4] = nArray[n5];
            nArray2[n4] = nArray2[n5];
            nArray[n5] = n6;
            nArray2[n5] = n7;
        }
        return n5;
    }

    public static final void sort(float[] fArray, int[] nArray) {
        ArrayLib.mergesort(fArray, nArray, 0, fArray.length - 1);
    }

    public static final void sort(float[] fArray, int[] nArray, int n) {
        ArrayLib.mergesort(fArray, nArray, 0, n - 1);
    }

    public static final void sort(float[] fArray, int[] nArray, int n, int n2) {
        ArrayLib.mergesort(fArray, nArray, n, n2 - 1);
    }

    public static final void insertionsort(float[] fArray, int[] nArray, int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            float f = fArray[i];
            int n3 = nArray[i];
            for (int j = i - 1; j >= n && fArray[j] > f; --j) {
                fArray[j + 1] = fArray[j];
                nArray[j + 1] = nArray[j];
            }
            fArray[j + 1] = f;
            nArray[j + 1] = n3;
        }
    }

    public static final void mergesort(float[] fArray, int[] nArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        if (n2 - n + 1 < 1000) {
            ArrayLib.insertionsort(fArray, nArray, n, n2);
        } else {
            int n3 = (n + n2) / 2;
            ArrayLib.mergesort(fArray, nArray, n, n3);
            ArrayLib.mergesort(fArray, nArray, n3 + 1, n2);
            ArrayLib.merge(fArray, nArray, n, n3, n2);
        }
    }

    public static final void merge(float[] fArray, int[] nArray, int n, int n2, int n3) {
        float[] fArray2 = new float[n3 - n + 1];
        int[] nArray2 = new int[n3 - n + 1];
        int n4 = n;
        int n5 = n2 + 1;
        int n6 = 0;
        while (n4 <= n2 && n5 <= n3) {
            if (fArray[n4] < fArray[n5]) {
                nArray2[n6] = nArray[n4];
                fArray2[n6] = fArray[n4++];
            } else {
                nArray2[n6] = nArray[n5];
                fArray2[n6] = fArray[n5++];
            }
            ++n6;
        }
        while (n4 <= n2) {
            nArray2[n6] = nArray[n4];
            fArray2[n6] = fArray[n4];
            ++n4;
            ++n6;
        }
        while (n5 <= n3) {
            nArray2[n6] = nArray[n5];
            fArray2[n6] = fArray[n5];
            ++n5;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n6 < fArray2.length) {
            nArray[n4] = nArray2[n6];
            fArray[n4] = fArray2[n6];
            ++n6;
            ++n4;
        }
    }

    public static final void quicksort(float[] fArray, int[] nArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        int n3 = ArrayLib.partition(fArray, nArray, n, n2);
        ArrayLib.quicksort(fArray, nArray, n, n3);
        ArrayLib.quicksort(fArray, nArray, n3 + 1, n2);
    }

    private static final int partition(float[] fArray, int[] nArray, int n, int n2) {
        float f = fArray[n];
        int n3 = n;
        int n4 = n2;
        while (true) {
            if (fArray[n4] > f) {
                --n4;
                continue;
            }
            while (fArray[n3] < f) {
                ++n3;
            }
            if (n3 >= n4) break;
            float f2 = fArray[n3];
            int n5 = nArray[n3];
            fArray[n3] = fArray[n4];
            nArray[n3] = nArray[n4];
            fArray[n4] = f2;
            nArray[n4] = n5;
        }
        return n4;
    }

    public static int[] getIntArray(String string) {
        int[] nArray = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            nArray = new int[n];
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith("#")) continue;
                nArray[n2++] = Integer.parseInt(string3);
            }
            if (n2 != n) {
                nArray = ArrayLib.trim(nArray, n2);
            }
            return nArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

