/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.util.display;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.util.display.ScaleSelector;
import edu.berkeley.guir.prefuse.util.io.IOLib;
import edu.berkeley.guir.prefuse.util.io.SimpleFileFilter;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ExportDisplayAction
extends AbstractAction {
    private Display display;
    private JFileChooser chooser;
    private ScaleSelector scaler;

    public ExportDisplayAction(Display display) {
        this.display = display;
        this.scaler = new ScaleSelector();
        this.chooser = new JFileChooser();
        this.chooser.setDialogType(1);
        this.chooser.setDialogTitle("Export Prefuse Display...");
        this.chooser.setAcceptAllFileFilterUsed(false);
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].toLowerCase();
            if (string.length() != 3 || hashSet.contains(string)) continue;
            hashSet.add(string);
            this.chooser.setFileFilter(new SimpleFileFilter(string, string.toUpperCase() + " Image (*." + string + ")"));
        }
        hashSet.clear();
        hashSet = null;
        this.chooser.setAccessory(this.scaler);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file = null;
        this.scaler.setImage(this.display.getOffscreenBuffer());
        int n = this.chooser.showSaveDialog(this.display);
        if (n != 0) {
            return;
        }
        file = this.chooser.getSelectedFile();
        String string = ((SimpleFileFilter)this.chooser.getFileFilter()).getExtension();
        String string2 = IOLib.getExtension(file);
        if (!string.equals(string2)) {
            file = new File(file.toString() + "." + string);
        }
        double d = this.scaler.getScale();
        boolean bl = false;
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            System.out.print("Saving image " + file.getName() + ", " + string + " format...");
            bl = this.display.saveImage(bufferedOutputStream, string, d);
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            System.out.println("\tDONE");
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this.display, "Error Saving Image!", "Image Save Error", 0);
        }
    }
}

