/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.controls;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.action.assignment.Layout;
import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class AnchorUpdateControl
extends ControlAdapter {
    private Layout[] m_layouts;
    private Activity m_activity;
    private Point2D m_tmp = new Point2D.Float();

    public AnchorUpdateControl(Layout layout) {
        this(layout, null);
    }

    public AnchorUpdateControl(Layout layout, Activity activity) {
        this(new Layout[]{layout}, activity);
    }

    public AnchorUpdateControl(Layout[] layoutArray, Activity activity) {
        this.m_layouts = (Layout[])layoutArray.clone();
        this.m_activity = activity;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        for (int i = 0; i < this.m_layouts.length; ++i) {
            this.m_layouts[i].setLayoutAnchor(null);
        }
        if (this.m_activity != null) {
            this.m_activity.runNow();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.moveEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveEvent(mouseEvent);
    }

    public void moveEvent(MouseEvent mouseEvent) {
        Display display = (Display)mouseEvent.getSource();
        display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.m_tmp);
        for (int i = 0; i < this.m_layouts.length; ++i) {
            this.m_layouts[i].setLayoutAnchor(this.m_tmp);
        }
        if (this.m_activity != null) {
            this.m_activity.runNow();
        }
    }
}

