/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.controls;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;

public class NeighborHighlightControl
extends ControlAdapter {
    private Activity update = null;
    private boolean highlightWithInvisibleEdge = false;

    public NeighborHighlightControl() {
        this(null);
    }

    public NeighborHighlightControl(Activity activity) {
        this.update = activity;
    }

    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        if (visualItem instanceof NodeItem) {
            this.setNeighborHighlight((NodeItem)visualItem, true);
        }
    }

    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (visualItem instanceof NodeItem) {
            this.setNeighborHighlight((NodeItem)visualItem, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeighborHighlight(NodeItem nodeItem, boolean bl) {
        ItemRegistry itemRegistry;
        ItemRegistry itemRegistry2 = itemRegistry = nodeItem.getItemRegistry();
        synchronized (itemRegistry2) {
            Iterator iterator = nodeItem.getEdges();
            while (iterator.hasNext()) {
                EdgeItem edgeItem = (EdgeItem)iterator.next();
                NodeItem nodeItem2 = (NodeItem)edgeItem.getAdjacentNode(nodeItem);
                if (!edgeItem.isVisible() && !this.highlightWithInvisibleEdge) continue;
                edgeItem.setHighlighted(bl);
                itemRegistry.touch(edgeItem.getItemClass());
                nodeItem2.setHighlighted(bl);
                itemRegistry.touch(nodeItem2.getItemClass());
            }
        }
        if (this.update != null) {
            this.update.runNow();
        }
    }

    public boolean isHighlightWithInvisibleEdge() {
        return this.highlightWithInvisibleEdge;
    }

    public void setHighlightWithInvisibleEdge(boolean bl) {
        this.highlightWithInvisibleEdge = bl;
    }
}

