/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.controls;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.event.ControlAdapter;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class PanControl
extends ControlAdapter {
    private int xDown;
    private int yDown;
    private boolean repaint = true;

    public PanControl() {
        this(true);
    }

    public PanControl(boolean bl) {
        this.repaint = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(13));
            this.xDown = mouseEvent.getX();
            this.yDown = mouseEvent.getY();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Display display = (Display)mouseEvent.getComponent();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.xDown;
            int n4 = n2 - this.yDown;
            display.pan(n3, n4);
            this.xDown = n;
            this.yDown = n2;
            if (this.repaint) {
                display.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            this.xDown = -1;
            this.yDown = -1;
        }
    }
}

