/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.force;

import edu.berkeley.guir.prefusex.force.Force;
import edu.berkeley.guir.prefusex.force.ForceItem;
import edu.berkeley.guir.prefusex.force.ForceSimulator;
import edu.berkeley.guir.prefusex.force.Spring;

public abstract class AbstractForce
implements Force {
    protected float[] params;

    public void init(ForceSimulator forceSimulator) {
    }

    public int getParameterCount() {
        return this.params == null ? 0 : this.params.length;
    }

    public float getParameter(int n) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[n];
    }

    public String getParameterName(int n) {
        String[] stringArray = this.getParameterNames();
        if (n < 0 || stringArray == null || n >= stringArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return stringArray[n];
    }

    public void setParameter(int n, float f) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.params[n] = f;
    }

    protected abstract String[] getParameterNames();

    public boolean isItemForce() {
        return false;
    }

    public boolean isSpringForce() {
        return false;
    }

    public void getForce(ForceItem forceItem) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }

    public void getForce(Spring spring) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }
}

