/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.layout;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.assignment.TreeLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SquarifiedTreeMapLayout
extends TreeLayout {
    private static Comparator s_cmp = new Comparator(){

        public int compare(Object object, Object object2) {
            double d;
            double d2 = ((VisualItem)object).getSize();
            return d2 > (d = ((VisualItem)object2).getSize()) ? 1 : (d2 < d ? -1 : 0);
        }
    };
    private ArrayList m_kids = new ArrayList();
    private ArrayList m_row = new ArrayList();
    private Rectangle2D m_r = new Rectangle2D.Double();
    private double m_frame;

    public SquarifiedTreeMapLayout() {
        this(0.0);
    }

    public SquarifiedTreeMapLayout(double d) {
        this.m_frame = d;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        NodeItem nodeItem = this.getLayoutRoot(itemRegistry);
        this.m_r.setRect(this.getLayoutBounds(itemRegistry));
        nodeItem.setLocation(0.0, 0.0);
        Point2D.Double double_ = new Point2D.Double(this.m_r.getWidth(), this.m_r.getHeight());
        nodeItem.setVizAttribute("dimension", double_);
        this.updateArea(nodeItem, this.m_r);
        this.layout(nodeItem, this.m_r);
    }

    private void layout(NodeItem nodeItem, Rectangle2D rectangle2D) {
        Iterator iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            this.m_kids.add(iterator.next());
        }
        Collections.sort(this.m_kids, s_cmp);
        double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
        this.squarify(this.m_kids, this.m_row, d, rectangle2D);
        this.m_kids.clear();
        iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            if (nodeItem2.getChildCount() <= 0) continue;
            this.updateArea(nodeItem2, rectangle2D);
            this.layout(nodeItem2, rectangle2D);
        }
    }

    private void updateArea(NodeItem nodeItem, Rectangle2D rectangle2D) {
        Point2D point2D = (Point2D)nodeItem.getVizAttribute("dimension");
        if (this.m_frame == 0.0) {
            rectangle2D.setRect(nodeItem.getX(), nodeItem.getY(), point2D.getX(), point2D.getY());
            return;
        }
        double d = 2.0 * this.m_frame * (point2D.getX() + point2D.getY() - 2.0 * this.m_frame);
        double d2 = nodeItem.getSize() - d;
        double d3 = 0.0;
        Iterator iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            d3 += ((NodeItem)iterator.next()).getSize();
        }
        double d4 = d2 / d3;
        iterator = nodeItem.getChildren();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            nodeItem2.setSize(nodeItem2.getSize() * d4);
        }
        rectangle2D.setRect(nodeItem.getX() + this.m_frame, nodeItem.getY() + this.m_frame, point2D.getX() - 2.0 * this.m_frame, point2D.getY() - 2.0 * this.m_frame);
    }

    private void squarify(List list, List list2, double d, Rectangle2D rectangle2D) {
        int n;
        double d2 = Double.MAX_VALUE;
        while ((n = list.size()) > 0) {
            list2.add(list.get(n - 1));
            double d3 = this.worst(list2, d);
            if (d3 <= d2) {
                list.remove(n - 1);
                d2 = d3;
                continue;
            }
            list2.remove(list2.size() - 1);
            rectangle2D = this.layoutRow(list2, d, rectangle2D);
            d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
            list2.clear();
            d2 = Double.MAX_VALUE;
        }
        if (list2.size() > 0) {
            rectangle2D = this.layoutRow(list2, d, rectangle2D);
            list2.clear();
        }
    }

    private double worst(List list, double d) {
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d5 = ((VisualItem)iterator.next()).getSize();
            d3 = Math.min(d3, d5);
            d2 = Math.max(d2, d5);
            d4 += d5;
        }
        d4 *= d4;
        d *= d;
        return Math.max(d * d2 / d4, d4 / (d * d3));
    }

    private Rectangle2D layoutRow(List list, double d, Rectangle2D rectangle2D) {
        double d2 = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            d2 += ((VisualItem)iterator.next()).getSize();
        }
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getY();
        double d5 = 0.0;
        double d6 = d2 / d;
        boolean bl = d == rectangle2D.getWidth();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            if (bl) {
                this.setLocation(nodeItem, (NodeItem)nodeItem.getParent(), d3 + d5, d4);
            } else {
                this.setLocation(nodeItem, (NodeItem)nodeItem.getParent(), d3, d4 + d5);
            }
            double d7 = nodeItem.getSize() / d6;
            if (bl) {
                this.setNodeDimensions(nodeItem, d7, d6);
                d5 += d7;
                continue;
            }
            this.setNodeDimensions(nodeItem, d6, d7);
            d5 += d7;
        }
        if (bl) {
            rectangle2D.setRect(d3, d4 + d6, rectangle2D.getWidth(), rectangle2D.getHeight() - d6);
        } else {
            rectangle2D.setRect(d3 + d6, d4, rectangle2D.getWidth() - d6, rectangle2D.getHeight());
        }
        return rectangle2D;
    }

    private void setNodeDimensions(NodeItem nodeItem, double d, double d2) {
        Point2D point2D = (Point2D)nodeItem.getVizAttribute("dimension");
        if (point2D == null) {
            point2D = new Point2D.Double();
            nodeItem.setVizAttribute("dimension", point2D);
        }
        point2D.setLocation(d, d2);
    }
}

