/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.layout;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.assignment.TreeLayout;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.GraphLib;
import edu.berkeley.guir.prefuse.graph.Tree;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class TopDownTreeLayout
extends TreeLayout {
    private int ySep = 20;
    private int minXSep = 2;

    public void run(ItemRegistry itemRegistry, double d) {
        Graph graph = itemRegistry.getFilteredGraph();
        if (!(graph instanceof Tree)) {
            throw new IllegalStateException("This layout only works with a tree!");
        }
        Tree tree = (Tree)graph;
        NodeItem nodeItem = (NodeItem)tree.getRoot();
        int n = GraphLib.getTreeHeight(tree);
        TDEdge tDEdge = new TDEdge(n);
        TDEdge tDEdge2 = new TDEdge(n);
        this.layout(nodeItem, n, this.ySep, tDEdge, tDEdge2);
        Iterator iterator = tree.getNodes();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            TDParams tDParams = this.getParams(nodeItem2);
            this.setLocation(nodeItem2, (NodeItem)nodeItem2.getParent(), tDParams.x, tDParams.y);
        }
    }

    private void layout(NodeItem nodeItem, int n, int n2, TDEdge tDEdge, TDEdge tDEdge2) {
        int n3;
        Object object;
        Rectangle2D rectangle2D = nodeItem.getBounds();
        int n4 = (int)Math.round(rectangle2D.getHeight());
        int n5 = (int)Math.round(rectangle2D.getWidth());
        int n6 = nodeItem.getChildCount();
        if (n6 == 0) {
            tDEdge.yloc = n2 + n4 - 1;
            tDEdge2.yloc = n2 + n4 - 1;
        } else {
            TDEdge[] tDEdgeArray = new TDEdge[n6];
            TDEdge[] tDEdgeArray2 = new TDEdge[n6];
            object = nodeItem.getChildren();
            n3 = 0;
            while (object.hasNext()) {
                tDEdgeArray[n3] = new TDEdge(n);
                tDEdgeArray2[n3] = new TDEdge(n);
                this.layout((NodeItem)object.next(), n, n2 + n4 + this.ySep, tDEdgeArray[n3], tDEdgeArray2[n3]);
                ++n3;
            }
            tDEdge = tDEdgeArray[0];
            tDEdge2 = tDEdgeArray2[0];
            object = nodeItem.getChildren();
            NodeItem nodeItem2 = (NodeItem)object.next();
            TDParams tDParams = this.getParams(nodeItem2);
            tDParams.x = 0;
            n3 = 1;
            while (object.hasNext()) {
                int n7;
                nodeItem2 = (NodeItem)object.next();
                tDParams = this.getParams(nodeItem2);
                int n8 = 0;
                for (n7 = n2 + n4 + this.ySep; n7 <= Math.min(tDEdgeArray[n3].yloc, tDEdge2.yloc); ++n7) {
                    n8 = Math.max(n8, tDEdgeArray[n3].offset[n7] + tDEdge2.offset[n7]);
                }
                tDParams.x = n8 + this.minXSep;
                for (n7 = tDEdge.yloc + 1; n7 <= tDEdgeArray[n3].yloc; ++n7) {
                    tDEdge.offset[n7] = tDEdgeArray[n3].offset[n7] - tDParams.x;
                }
                tDEdge.yloc = Math.max(tDEdge.yloc, tDEdgeArray[n3].yloc);
                for (n7 = n2; n7 <= tDEdgeArray2[n3].yloc; ++n7) {
                    tDEdge2.offset[n7] = tDEdgeArray2[n3].offset[n7] + tDParams.x;
                }
                tDEdge2.yloc = Math.max(tDEdge2.yloc, tDEdgeArray2[n3].yloc);
                ++n3;
            }
            if (n6 > 1) {
                nodeItem2 = (NodeItem)nodeItem.getChild(n6 - 1);
                tDParams = this.getParams(nodeItem2);
                int n9 = tDParams.x / 2;
                for (n3 = 0; n3 < n6; ++n3) {
                }
                tDParams.x -= n9;
                n3 = n2;
                while (n3 <= tDEdge.yloc) {
                    int n10 = n3++;
                    tDEdge.offset[n10] = tDEdge.offset[n10] + n9;
                }
                n3 = n2;
                while (n3 <= tDEdge2.yloc) {
                    int n11 = n3++;
                    tDEdge2.offset[n11] = tDEdge2.offset[n11] - n9;
                }
            }
            tDEdgeArray2 = null;
            tDEdgeArray = null;
        }
        for (n3 = n2 - this.ySep; n3 < n2 + n4; ++n3) {
            tDEdge.offset[n3] = n5 / 2;
            tDEdge2.offset[n3] = (n5 + 1) / 2;
        }
        object = this.getParams(nodeItem);
        ((TDParams)object).y = n2;
    }

    private TDParams getParams(VisualItem visualItem) {
        TDParams tDParams = (TDParams)visualItem.getVizAttribute("tdParams");
        if (tDParams == null) {
            tDParams = new TDParams();
            visualItem.setVizAttribute("tdParams", tDParams);
        }
        return tDParams;
    }

    public class TDEdge {
        int yloc;
        int[] offset;

        public TDEdge() {
        }

        public TDEdge(int n) {
            this.offset = new int[n];
        }
    }

    public class TDParams {
        int x;
        int y;
    }
}

