/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.ChartHolder;
import de.laures.cewolf.ChartPostProcessor;
import de.laures.cewolf.ChartValidationException;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.PostProcessingException;
import de.laures.cewolf.event.ChartImageRenderListener;
import de.laures.cewolf.taglib.TaglibConstants;
import de.laures.cewolf.util.ImageHelper;
import de.laures.cewolf.util.RenderedImage;
import java.awt.Image;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.title.LegendTitle;
import org.jfree.ui.RectangleEdge;

public abstract class AbstractChartDefinition
implements ChartHolder,
Serializable,
TaglibConstants,
ChartImageRenderListener {
    protected static Log log = LogFactory.getLog((Class)(class$de$laures$cewolf$taglib$AbstractChartDefinition == null ? (class$de$laures$cewolf$taglib$AbstractChartDefinition = AbstractChartDefinition.class$("de.laures.cewolf.taglib.AbstractChartDefinition")) : class$de$laures$cewolf$taglib$AbstractChartDefinition));
    protected String title;
    protected String xAxisLabel;
    protected String yAxisLabel;
    protected String type;
    private boolean antialias = true;
    private String background;
    private float backgroundImageAlpha = 1.0f;
    private Paint paint;
    private int legendAnchor = 101;
    private boolean showLegend = true;
    private transient List postProcessors = new ArrayList();
    private List postProcessorsParams = new ArrayList();
    private transient JFreeChart chart;
    static /* synthetic */ Class class$de$laures$cewolf$taglib$AbstractChartDefinition;

    protected abstract JFreeChart produceChart() throws DatasetProduceException, ChartValidationException;

    public LegendTitle getLegend() {
        LegendTitle legend = null;
        List subTitles = this.chart.getSubtitles();
        Iterator iter = subTitles.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof LegendTitle)) continue;
            legend = (LegendTitle)o;
            break;
        }
        return legend;
    }

    public void removeLegend() {
        List subTitles = this.chart.getSubtitles();
        Iterator iter = subTitles.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof LegendTitle)) continue;
            iter.remove();
            break;
        }
    }

    public Object getChart() throws DatasetProduceException, ChartValidationException, PostProcessingException {
        if (this.chart == null) {
            this.chart = this.produceChart();
            this.chart.setAntiAlias(this.antialias);
            if (this.background != null) {
                Image image = ImageHelper.loadImage(this.background);
                this.chart.setBackgroundImage(image);
                this.chart.setBackgroundImageAlpha(this.backgroundImageAlpha);
            }
            if (this.paint != null) {
                this.chart.setBackgroundPaint(this.paint);
            }
            if (this.showLegend) {
                LegendTitle legend = this.getLegend();
                switch (this.legendAnchor) {
                    case 100: {
                        legend.setPosition(RectangleEdge.TOP);
                        break;
                    }
                    case 103: {
                        legend.setPosition(RectangleEdge.RIGHT);
                        break;
                    }
                    case 102: {
                        legend.setPosition(RectangleEdge.LEFT);
                        break;
                    }
                    default: {
                        legend.setPosition(RectangleEdge.BOTTOM);
                        break;
                    }
                }
            } else {
                this.removeLegend();
            }
            for (int i = 0; i < this.postProcessors.size(); ++i) {
                ChartPostProcessor pp = (ChartPostProcessor)this.postProcessors.get(i);
                try {
                    pp.processChart(this.chart, (Map)this.postProcessorsParams.get(i));
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)t);
                    throw new PostProcessingException(t.getClass().getName() + " raised by post processor '" + pp + "'.\nPost processing of this post processor " + "has been ignored.");
                }
            }
        }
        return this.chart;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public void setBackgroundImageAlpha(float backgroundImageAlpha) {
        this.backgroundImageAlpha = backgroundImageAlpha;
    }

    public void setLegendAnchor(int legendAnchor) {
        this.legendAnchor = legendAnchor;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public void addPostProcessor(ChartPostProcessor pp) {
        this.postProcessors.add(pp);
    }

    public void addPostProcessorParams(Map params) {
        this.postProcessorsParams.add(params);
    }

    public void onImageRendered(RenderedImage renderedImage) {
        for (int i = 0; i < this.postProcessors.size(); ++i) {
            ChartPostProcessor pp = (ChartPostProcessor)this.postProcessors.get(i);
            if (!(pp instanceof ChartImageRenderListener)) continue;
            ((ChartImageRenderListener)((Object)pp)).onImageRendered(renderedImage);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ Object getDataset() throws DatasetProduceException;
}

