/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.tags;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartHolder;
import de.laures.cewolf.Configuration;
import de.laures.cewolf.Storage;
import de.laures.cewolf.WebConstants;
import de.laures.cewolf.taglib.ChartImageDefinition;
import de.laures.cewolf.taglib.TaglibConstants;
import de.laures.cewolf.taglib.html.HTMLImgTag;
import de.laures.cewolf.taglib.tags.CewolfRootTag;
import de.laures.cewolf.taglib.tags.ChartImgTag;
import de.laures.cewolf.taglib.util.PageUtils;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class LegendTag
extends HTMLImgTag
implements CewolfRootTag,
TaglibConstants,
WebConstants {
    private static final String DEFAULT_MIME_TYPE = "image/png";
    private static final int DEFAULT_TIMEOUT = 300;
    private int timeout = 300;
    private transient String sessionKey;
    private transient String renderer;
    private String mimeType = "image/png";

    public int doStartTag() throws JspException {
        ChartHolder cd = PageUtils.getChartHolder(this.getChartId(), ((TagSupport)this).pageContext);
        ChartImageDefinition cid = new ChartImageDefinition(cd, this.width, this.height, 1, this.mimeType, this.timeout);
        Storage storage = Configuration.getInstance(((TagSupport)this).pageContext.getServletContext()).getStorage();
        try {
            this.sessionKey = storage.storeChartImage(cid, ((TagSupport)this).pageContext);
        }
        catch (CewolfException cwex) {
            this.log.error((Object)cwex);
            throw new JspException(cwex.getMessage());
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        super.doStartTag();
        StringBuffer buffer = new StringBuffer(" src=\"");
        buffer.append(this.getImgURL());
        buffer.append("\"");
        try {
            ((TagSupport)this).pageContext.getOut().write(buffer.toString());
        }
        catch (IOException ioex) {
            this.reset();
            this.log.error((Object)ioex);
            throw new JspException(ioex.getMessage());
        }
        return super.doEndTag();
    }

    protected String getImgURL() {
        return ChartImgTag.buildImgURL(this.renderer, ((TagSupport)this).pageContext, this.sessionKey, this.width, this.height, this.mimeType);
    }

    protected void reset() {
        int lHeight = this.height;
        int lWidth = this.width;
        int lTimeout = this.timeout;
        super.reset();
        this.height = lHeight;
        this.width = lWidth;
        this.timeout = lTimeout;
    }

    public String getChartId() {
        return this.getId();
    }

    public void setRenderer(String rend) {
        this.renderer = rend;
    }

    public void setMime(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

