/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.action.Action;
import edu.berkeley.guir.prefuse.activity.ActionList;
import edu.berkeley.guir.prefuse.event.ControlListener;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.render.DefaultRendererFactory;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.RendererFactory;
import edu.berkeley.guir.prefusex.controls.DragControl;
import edu.berkeley.guir.prefusex.controls.NeighborHighlightControl;
import edu.berkeley.guir.prefusex.controls.PanControl;
import edu.berkeley.guir.prefusex.controls.ZoomControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.mitre.mrald.graphics.DBGraphReader;
import org.mitre.mrald.graphics.MraldDBPanel;
import org.mitre.mrald.graphics.MraldEdgeRenderer;
import org.mitre.mrald.graphics.MraldVizApplet;
import org.mitre.mrald.graphics.TableNodeRenderer;
import org.mitre.mrald.graphics.VisualColorFunction;

public class DBViewerApplet
extends MraldVizApplet {
    public void init() {
        String inputFile = this.getParameter("fileName");
        Graph g = null;
        try {
            URL inputUrl = DBViewerApplet.class.getResource("/" + inputFile);
            g = new DBGraphReader().loadGraph(inputUrl);
            URL baseUrl = new URL(this.getParameter("baseURL"));
            ItemRegistry registry = new ItemRegistry(g);
            Display display = new Display(registry);
            display.setSize(500, 500);
            display.pan(250.0, 250.0);
            registry.setRendererFactory((RendererFactory)this.initRenderers("label"));
            ActionList filter = new ActionList(registry);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            String propsFile = "settings.props";
            Properties settings = this.loadProperties(propsFile);
            attributes.put("settings", settings);
            attributes.put("BoxColor", new Color(216, 210, 195));
            attributes.put("PanelColor", new Color(243, 242, 235));
            attributes.put("SpringCoefficient", "Contract/Expand");
            attributes.put("registry", registry);
            attributes.put("display", display);
            VisualColorFunction colorFunc = new VisualColorFunction();
            attributes.put("colorSet", (Object)colorFunc);
            attributes.put("baseURL", baseUrl);
            this.forces = new ActionList(registry, -1L, 20L);
            PanControl pc = new PanControl(false);
            ZoomControl zc = new ZoomControl(false);
            String displayType = this.getParameter("displayType");
            if (displayType != null) {
                if (displayType.equals("Vertical")) {
                    this.createVerticalGraph(display, filter, zc, pc);
                } else if (displayType.equals("Radial")) {
                    this.createRadialGraph(display, filter, zc, pc);
                } else if (displayType.equals("Jung")) {
                    this.createJungGraph(display, filter);
                } else if (displayType.equals("Balloon")) {
                    this.createBalloonGraph(display, filter, registry);
                } else if (displayType.equals("Distort")) {
                    this.createDistortGraph(display, filter);
                } else if (displayType.equals("Force")) {
                    this.createForceGraph(display, filter, attributes, registry);
                }
            } else {
                this.createForceGraph(display, filter, attributes, registry);
            }
            this.forces.add((Action)colorFunc);
            attributes.put("forces", this.forces);
            MraldDBPanel fpanel = new MraldDBPanel(attributes);
            Container c = this.getContentPane();
            c.setLayout(new BorderLayout());
            c.add((Component)fpanel, "South");
            display.addControlListener((ControlListener)new NeighborHighlightControl());
            display.addControlListener((ControlListener)new DragControl(false, true));
            display.addControlListener((ControlListener)pc);
            display.addControlListener((ControlListener)zc);
            this.getContentPane().add((Component)display);
            filter.runNow();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void start() {
        this.forces.runNow();
    }

    public void stop() {
        this.forces.cancel();
    }

    private DefaultRendererFactory initRenderers(String textField) {
        try {
            int i;
            URL baseUrl = new URL(this.getParameter("baseURL") + "/graphics");
            if (baseUrl == null) {
                System.out.println("DBViewer Applet: codebaseUrl is null");
            } else {
                System.out.println("DBViewer Applet: codebaseUrl is NOT null " + baseUrl);
            }
            TableNodeRenderer nodeRenderer = new TableNodeRenderer(baseUrl);
            nodeRenderer.setCodeBaseUrl(baseUrl);
            nodeRenderer.setRenderType(2);
            nodeRenderer.setRoundedCorner(8, 8);
            Font mfont = new Font("SansSerif", 1, 10);
            nodeRenderer.setTextAttributeName(textField);
            nodeRenderer.addTextAttribute(textField, 3, mfont);
            int noOfEntries = 70;
            for (i = 1; i < noOfEntries + 1; ++i) {
                nodeRenderer.addTextAttribute("column" + i, 3);
            }
            for (i = 1; i < noOfEntries + 1; ++i) {
                nodeRenderer.addTextAttribute("type" + i, 3);
            }
            MraldEdgeRenderer edgeRenderer = new MraldEdgeRenderer();
            edgeRenderer.setWeightType(0);
            edgeRenderer.setEdgeType(0);
            return new DefaultRendererFactory((Renderer)nodeRenderer, (Renderer)edgeRenderer, null);
        }
        catch (Exception e) {
            System.out.println("Exception : INit Renderers: " + e.getMessage());
            return null;
        }
    }
}

