/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.KeywordSearch;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TableMetaData;

public class DataQuestKeywordSearch
extends KeywordSearch {
    public String search(String[] searchParams) throws MraldException {
        try {
            Connection conn = new MraldConnection("main").getConnection();
            Statement stmt = conn.createStatement();
            ArrayList<String> headers = new ArrayList<String>();
            StringBuffer strRtn = new StringBuffer();
            headers.add("piname");
            headers.add("granttitle");
            headers.add("fundingagency");
            headers.add("datasetid");
            String headerStr = "<tr><th colspan=\"2\" bgcolor=\"#ccccff\"><:" + ((String)headers.get(0)).toString() + ":> - <:" + ((String)headers.get(1)).toString() + ":> - <:" + ((String)headers.get(2)).toString() + ":> (<a href=\"details.jsp?DataSetID=<:" + ((String)headers.get(3)).toString() + ":>\">Details</a>)</th></tr>";
            if (searchParams.length < 1) {
                strRtn.append("\nYou must enter a search criteria.\n");
                return strRtn.toString();
            }
            DBMetaData md = MetaData.getDbMetaData(this.datasource);
            Collection<TableMetaData> tableMetaData = md.getAllTableMetaData();
            for (TableMetaData tableInfo : tableMetaData) {
                ArrayList fieldNames = (ArrayList)tableInfo.getColumnNames();
                Iterator iter2 = fieldNames.iterator();
                String whereClause = "";
                if (iter2 == null || !iter2.hasNext()) {
                    // empty if block
                }
                while (iter2.hasNext()) {
                    String field = (String)iter2.next();
                    Integer type = tableInfo.getFieldType(field);
                    if (FBUtils.isNumberType(type) || FBUtils.isDateType(type) || FBUtils.isBooleanType(type)) continue;
                    whereClause = whereClause + " UPPER (" + field + ") like '%" + searchParams[0].toUpperCase() + "%' OR ";
                }
                if (whereClause.equals("")) continue;
                whereClause = whereClause + "1=0";
                String query = "select * from " + tableInfo.getName() + " where " + whereClause;
                ResultSet rs = stmt.executeQuery(query);
                StringBuffer strOut = new StringBuffer();
                String projectId = "-1";
                String dataSetId = "-1";
                while (rs.next()) {
                    headerStr = "<TR><TH COLSPAN=\"2\" BGCOLOR=\"#ccccff\"><:" + ((String)headers.get(0)).toString() + ":> - <:" + ((String)headers.get(1)).toString() + ":> - <:" + ((String)headers.get(2)).toString() + ":> (<A HREF=\"details.jsp?DataSetID=<:" + ((String)headers.get(3)).toString() + ":>\">Details</A>)</TH></TR>";
                    strOut = new StringBuffer();
                    strOut.append("\n\t");
                    for (int i = 0; i < fieldNames.size(); ++i) {
                        String fieldName;
                        String value = rs.getString(i + 1);
                        if (value == null || (fieldName = fieldNames.get(i).toString().toLowerCase()).equals("email") || fieldName.equals("phone")) continue;
                        if (fieldName.equals("projectid")) {
                            projectId = value;
                        }
                        if (fieldName.equals("datasetid")) {
                            dataSetId = value;
                        }
                        if (headers.contains(fieldName)) {
                            headerStr = headerStr.replaceAll("<:" + fieldName + ":>", value);
                        }
                        strOut.append("<TR><TD ALIGN=\"right\" WIDTH=\"15%\">");
                        strOut.append(fieldNames.get(i).toString());
                        strOut.append("</TD>");
                        strOut.append("<TD>&nbsp;" + value + "</TD></TR>");
                    }
                    if (tableInfo.getName().toLowerCase().equals("dataset")) {
                        headerStr = this.getProjectInfo(headerStr, dataSetId, conn);
                    }
                    if (tableInfo.getName().toLowerCase().equals("project")) {
                        headerStr = headerStr.replaceAll("DataSetID", "ProjectID");
                        headerStr = headerStr.replaceAll("<:datasetid:>", projectId);
                    }
                    strRtn.append(headerStr + strOut.toString());
                }
            }
            return strRtn.toString();
        }
        catch (SQLException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }

    private String getProjectInfo(String header, String datasetid, Connection conn) throws MraldException {
        try {
            String sql = "select granttitle, grantnumber, fundingagency, piname from project, dataset where datasetid = '" + datasetid + "'";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                header = header.replaceAll("<:piname:>", rs.getString("piname"));
                header = header.replaceAll("<:granttitle:>", rs.getString("granttitle"));
                header = header.replaceAll("<:fundingagency:>", rs.getString("fundingagency"));
            }
            return header;
        }
        catch (SQLException e) {
            MraldException se = new MraldException(e);
            throw se;
        }
    }
}

