/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.TableMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class FBUtils {
    public static final String ROW_END = "</tr>";
    public static final String ROW_START = "<tr>";
    public static final String TABLE_END = "\n</table>";
    public static final String TABLE_START = "\n<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">";
    protected static final ArrayList<Integer> dateTypes = new ArrayList();
    protected static final ArrayList<Integer> numberTypes = new ArrayList();
    protected static final ArrayList<Integer> binaryTypes = new ArrayList();
    protected static final ArrayList<Integer> booleanTypes = new ArrayList();
    private static Properties columnNames;
    private static PropertyChangeListener pcl;

    public static String getColumnName(String tableDotField) {
        if (columnNames == null) {
            FBUtils.initColumnNames();
            Config.addPropertyChangeListener(pcl);
        }
        return (String)columnNames.get(tableDotField);
    }

    public static void addColumnNames(Properties newProps) {
        if (columnNames == null) {
            FBUtils.getColumnName("dummy to get the columnNames to initialize - so I don't have to duplicate code");
        }
        boolean changed = false;
        Enumeration<?> e = newProps.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = columnNames.getProperty(name);
            if (value != null) continue;
            changed = true;
            columnNames.setProperty(name, newProps.getProperty(name));
        }
        if (changed) {
            try {
                String base_path = Config.getProperty("BasePath");
                File config_file = new File(base_path + "/WEB-INF/props/columnNames.props");
                FileOutputStream fout = new FileOutputStream(config_file);
                columnNames.store(fout, "modified for new form");
                fout.close();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static StringBuffer getOperatorList(String name, String operatorNumber) {
        StringBuffer opList = new StringBuffer();
        opList.append("\n<select name=\"");
        opList.append(name);
        opList.append("\">");
        opList.append("<option value=\"Operator" + operatorNumber + ":=\">=</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":!=\">Not equal (!=)</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":<\">&lt;</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":>\">&gt;</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":<=\">&lt;=</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":>=\">&gt;=</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":like\">Contains</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":not like\">Does Not Contain</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":starts\">Starts With</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":not starts\">Does Not Start With</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":IN\">IN</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":NOT IN\">NOT IN</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":IS NULL\">IS NULL</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":IS NOT NULL\">IS NOT NULL</option>");
        opList.append("</select>");
        return opList;
    }

    public static StringBuffer getSimpleOperatorList(String name, String operatorNumber) {
        StringBuffer opList = new StringBuffer();
        opList.append("\n<select name=\"");
        opList.append(name);
        opList.append("\">");
        opList.append("<option value=\"Operator" + operatorNumber + ":=\">=</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":!=\">Not equal (!=)</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":<\">&lt;</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":>\">&gt;</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":<=\">&lt;=</option>");
        opList.append("<option value=\"Operator" + operatorNumber + ":>=\">&gt;=</option>");
        opList.append("</select>");
        return opList;
    }

    public static String getSqlType(int type) {
        switch (type) {
            case 2003: {
                return "ARRAY ";
            }
            case -5: {
                return "BIGINT ";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT ";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN ";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK ";
            }
            case 91: {
                return "DATE ";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE ";
            }
            case 6: {
                return "FLOAT ";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT ";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL ";
            }
            case 2006: {
                return "REF ";
            }
            case 5: {
                return "SMALLINT\t";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME ";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "VARCHAR";
    }

    public static boolean isDateType(int _type) {
        Integer type = new Integer(_type);
        return dateTypes.contains(type);
    }

    public static boolean isBooleanType(int _type) {
        Integer type = new Integer(_type);
        return booleanTypes.contains(type);
    }

    public static boolean isDateType(Integer type) {
        return dateTypes.contains(type);
    }

    public static boolean isNumberType(int _type) {
        Integer type = new Integer(_type);
        return numberTypes.contains(type);
    }

    public static boolean isNumberType(Integer type) {
        return numberTypes.contains(type);
    }

    public static boolean isBinaryType(Integer type) {
        return binaryTypes.contains(type);
    }

    public static boolean isBinaryType(int _type) {
        Integer type = new Integer(_type);
        return binaryTypes.contains(type);
    }

    public static boolean isBooleanType(Integer type) {
        return booleanTypes.contains(type);
    }

    public static StringBuffer buildTableFieldDropDown(DBMetaData md, String elementName, int num) {
        StringBuffer ret = new StringBuffer();
        ret.append("\n<select name=\"");
        ret.append(elementName);
        ret.append(num);
        ret.append("\">");
        ret.append("<option></option>");
        Collection<TableMetaData> tableMetaData = md.getAllTableMetaData();
        for (TableMetaData tableInfo : tableMetaData) {
            Collection<String> fieldNames = tableInfo.getColumnNames();
            for (String field : fieldNames) {
                ret.append("<option value=\"Table:");
                ret.append(tableInfo.getName());
                ret.append("~Field:");
                ret.append(field);
                ret.append("\">");
                ret.append(tableInfo.getName());
                ret.append(".");
                ret.append(field);
                ret.append("</option>");
            }
        }
        ret.append("</select>");
        return ret;
    }

    public static StringBuffer buildTableFieldDropDown(DBMetaData md, String elementName, int num, String tableName, String colName, String tableLit, String pkLit, String fieldLit) {
        StringBuffer ret = new StringBuffer();
        ret.append("\n<select name=\"");
        ret.append(elementName);
        ret.append(num);
        ret.append("\">");
        ret.append("<option></option>");
        TableMetaData tableInfo = md.getTableMetaData(tableName);
        if (tableInfo != null) {
            Collection<String> fieldNames = tableInfo.getColumnNames();
            for (String field : fieldNames) {
                ret.append("<option value=\"" + tableLit + ":");
                ret.append(tableInfo.getName());
                ret.append("~" + fieldLit + ":");
                ret.append(field);
                ret.append("~" + pkLit + ":" + colName);
                ret.append("\">");
                ret.append(tableInfo.getName());
                ret.append(".");
                ret.append(field);
                ret.append("</option>");
            }
        }
        ret.append("</select>");
        return ret;
    }

    protected static void initColumnNames() {
        FBUtils.loadProperties();
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                FBUtils.loadProperties();
            }
        };
    }

    public static void addTextNode(Document document, Element ret, String tag, String value) {
        Element typeElement = document.createElement(tag);
        Text typeText = document.createTextNode(value);
        typeElement.appendChild(typeText);
        ret.appendChild(typeElement);
    }

    protected static void loadProperties() {
        try {
            columnNames = MiscUtils.loadProperties(Config.getProperty("columnNamesProps"));
        }
        catch (RuntimeException e) {
            columnNames = new Properties();
        }
    }

    static {
        numberTypes.add(new Integer(-5));
        numberTypes.add(new Integer(3));
        numberTypes.add(new Integer(8));
        numberTypes.add(new Integer(6));
        numberTypes.add(new Integer(4));
        numberTypes.add(new Integer(2));
        numberTypes.add(new Integer(5));
        numberTypes.add(new Integer(-6));
        booleanTypes.add(new Integer(16));
        booleanTypes.add(new Integer(-7));
        binaryTypes.add(new Integer(2004));
        binaryTypes.add(new Integer(1111));
        binaryTypes.add(new Integer(-4));
        dateTypes.add(new Integer(91));
        dateTypes.add(new Integer(92));
        dateTypes.add(new Integer(93));
    }
}

