/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.InterfaceException;
import org.mitre.mrald.util.XSLTranslator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormUtils {
    MsgObject msg;

    public static boolean isXml(String text) {
        try {
            DocumentBuilder doc = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc.parse(new InputSource(new StringReader(text)));
        }
        catch (SAXException e) {
            return false;
        }
        catch (ParserConfigurationException e) {
            InterfaceException nu = new InterfaceException(e);
            throw nu;
        }
        catch (IOException e) {
            InterfaceException nu = new InterfaceException(e);
            throw nu;
        }
        return true;
    }

    public static void printFile(Writer output, File temp) throws IOException {
        FileInputStream fis = new FileInputStream(temp.toString());
        BufferedReader r = new BufferedReader(new InputStreamReader(fis));
        String currLine = r.readLine();
        while (currLine != null) {
            output.write(currLine);
            currLine = r.readLine();
        }
    }

    public static String getRedirect(String temp) throws IOException {
        String base = Config.getProperty("BasePath");
        String redirectFile = temp.substring(base.length());
        redirectFile = redirectFile.replace('\\', '/');
        return Config.getProperty("BaseUrl") + "/" + redirectFile;
    }

    public static String getSimpleJspName(String formId, String userid) {
        return userid + "_" + formId + "-simple.jsp";
    }

    public static String getJspFileName(String form, String userid) {
        return userid + "_" + form + ".jsp";
    }

    public static String getXmlFileName(String formid, String userid) {
        return userid + "_" + formid + ".xml";
    }

    public static void deleteJspsForForm(String[] formId, String userid) {
        for (int i = 0; i < formId.length; ++i) {
            FormUtils.deleteJspsForForm(formId[i], userid);
        }
    }

    public static void deleteJspsForForm(String formId, String userid) {
        String dir_struct = Config.getProperty("customForms");
        File jsp_file = new File(dir_struct + FormUtils.getJspFileName(formId, userid));
        File simple_jsp_file = new File(dir_struct + FormUtils.getSimpleJspName(formId, userid));
        jsp_file.delete();
        simple_jsp_file.delete();
    }

    public void copyForm(String currentUserId, String newformid, String[] userId) throws IOException, FileNotFoundException {
        for (int i = 0; i < userId.length; ++i) {
            this.copyForm(currentUserId, newformid, userId[i]);
        }
    }

    public void copyForm(String currentUserId, String newformid, String userId) throws IOException, FileNotFoundException {
        File jspSimpleSourceFile;
        File jspSourceFile;
        String destDir = Config.getProperty("customForms");
        File xmlSourceFile = new File(destDir, FormUtils.getXmlFileName(newformid, currentUserId));
        if (xmlSourceFile.exists()) {
            this.copyFile(xmlSourceFile, new File(destDir, FormUtils.getXmlFileName(newformid, userId)));
        }
        if ((jspSourceFile = new File(destDir, FormUtils.getJspFileName(newformid, currentUserId))).exists()) {
            this.copyFile(jspSourceFile, new File(destDir, FormUtils.getJspFileName(newformid, userId)));
        }
        if ((jspSimpleSourceFile = new File(destDir, FormUtils.getSimpleJspName(newformid, currentUserId))).exists()) {
            this.copyFile(jspSimpleSourceFile, new File(destDir, FormUtils.getSimpleJspName(newformid, userId)));
        }
    }

    public void deleteForm(String[] formId, String userId) throws IOException, FileNotFoundException {
        for (int i = 0; i < formId.length; ++i) {
            this.deleteForm(formId[i], userId);
        }
    }

    public void publishForm(String[] formId, String userId) throws IOException, FileNotFoundException {
        for (int i = 0; i < formId.length; ++i) {
            this.publishForm(formId[i], userId);
        }
    }

    private void publishForm(String formItem, String userId) throws IOException, FileNotFoundException {
        String sourceUserId;
        String destDir = Config.getProperty("customForms");
        userId = "public";
        String newformid = formItem.substring(formItem.indexOf("_") + 1, formItem.length());
        File xmlSourceFile = new File(destDir, FormUtils.getXmlFileName(newformid, sourceUserId = formItem.substring(0, formItem.indexOf("_"))));
        if (xmlSourceFile.exists()) {
            this.copyFile(xmlSourceFile, new File(destDir, FormUtils.getXmlFileName(newformid, userId)));
        } else {
            File jspSimpleSourceFile;
            File jspSourceFile = new File(destDir, FormUtils.getJspFileName(newformid, sourceUserId));
            if (jspSourceFile.exists()) {
                this.copyFile(jspSourceFile, new File(destDir, FormUtils.getJspFileName(newformid, userId)));
            }
            if ((jspSimpleSourceFile = new File(destDir, FormUtils.getSimpleJspName(newformid, sourceUserId))).exists()) {
                this.copyFile(jspSimpleSourceFile, new File(destDir, FormUtils.getSimpleJspName(newformid, userId)));
            }
        }
    }

    public void deleteForm(String formId, String userid) throws IOException, FileNotFoundException {
        File jspSourceFile;
        File xmlSourceFile;
        File deletedDir = new File(Config.getProperty("customForms"), "deleted");
        if (!deletedDir.exists()) {
            deletedDir.mkdirs();
        }
        if ((xmlSourceFile = new File(Config.getProperty("customForms"), FormUtils.getXmlFileName(formId, userid))).exists()) {
            this.copyFile(xmlSourceFile, new File(deletedDir, xmlSourceFile.getName()));
            xmlSourceFile.delete();
        }
        if ((jspSourceFile = new File(Config.getProperty("customForms"), FormUtils.getJspFileName(formId, userid))).exists()) {
            this.copyFile(jspSourceFile, new File(deletedDir, jspSourceFile.getName()));
            jspSourceFile.delete();
        }
        if ((jspSourceFile = new File(Config.getProperty("customForms"), FormUtils.getSimpleJspName(formId, userid))).exists()) {
            this.copyFile(jspSourceFile, new File(deletedDir, jspSourceFile.getName()));
            jspSourceFile.delete();
        }
    }

    public void downloadForm(HttpServletResponse response, String formid, String userid) throws IOException {
        String dir_struct = Config.getProperty("customForms");
        PrintWriter out = response.getWriter();
        File xml_file = new File(dir_struct + FormUtils.getXmlFileName(formid, userid));
        File jsp_file = new File(dir_struct + FormUtils.getJspFileName(formid, userid));
        if (xml_file.exists()) {
            response.setContentType("text/xml");
            response.setHeader("Content-Disposition", "attachment; filename=" + xml_file.getName() + ";");
            FormUtils.printFile(out, xml_file);
        } else if (jsp_file.exists()) {
            response.setContentType("text/html");
            response.setHeader("Content-Disposition", "attachment; filename=" + jsp_file.getName() + ";");
            FormUtils.printFile(out, jsp_file);
        } else {
            throw new RuntimeException("No form exists for formID=" + formid + " and userID=" + userid);
        }
    }

    public void storeForm(String newformid, String form, String userid) throws IOException {
        File new_file = FormUtils.isXml(form) ? new File(Config.getProperty("customForms"), FormUtils.getXmlFileName(newformid, userid)) : new File(Config.getProperty("customForms"), FormUtils.getJspFileName(newformid, userid));
        if (!new_file.exists() && !new_file.createNewFile()) {
            IOException e = new IOException("Could not create new file.  The form content was stored in the log file.");
            e.fillInStackTrace();
            throw e;
        }
        PrintWriter ret = new PrintWriter(new FileWriter(new_file));
        ret.println(form);
        ret.close();
    }

    public void copyFile(File sourceFile, File destFile) throws FileNotFoundException, IOException {
        int len;
        byte[] buffer = new byte[4096];
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        in.close();
        in = null;
        out = null;
    }

    public static void makeForm(File xmlfile) {
        String strippedXmlFileName = xmlfile.toString().substring(0, xmlfile.toString().indexOf(".xml"));
        String jspFileName = strippedXmlFileName + ".jsp";
        String simpleFileName = strippedXmlFileName + "-simple.jsp";
        String tinyFileName = strippedXmlFileName + "-tiny.jsp";
        File xslFile = new File(Config.getProperty("formStylesheet"));
        File simpleXslFile = new File(Config.getProperty("simpleStylesheet"));
        try {
            StringBuffer jspContents = XSLTranslator.xslTransform(xmlfile, xslFile);
            PrintWriter ret = new PrintWriter(new FileWriter(jspFileName));
            ret.print(jspContents);
            ret.flush();
            ret.close();
            jspContents = XSLTranslator.xslTransform(xmlfile, simpleXslFile);
            if (jspContents.indexOf("html") == -1) {
                return;
            }
            ret = new PrintWriter(new FileWriter(simpleFileName));
            ret.print(jspContents);
            ret.flush();
            ret.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void makeTinyForm(File xmlfile) {
        String strippedXmlFileName = xmlfile.toString().substring(0, xmlfile.toString().indexOf(".xml"));
        String tinyFileName = strippedXmlFileName + "-tiny.jsp";
        File tinyXslFile = new File(Config.getProperty("tinyStylesheet"));
        try {
            StringBuffer jspContents = XSLTranslator.xslTransform(xmlfile, tinyXslFile);
            if (jspContents.indexOf("html") == -1) {
                return;
            }
            PrintWriter ret = new PrintWriter(new FileWriter(tinyFileName));
            ret.print(jspContents);
            ret.flush();
            ret.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

