/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DataSource;
import org.mitre.mrald.util.MraldOutFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTemplates {
    public static final String XML_FILENAME = "jdbcStrings.xml";
    public static final String DATASOURCE_TAG = "datasource";
    private static Map<String, DataSource> templates = new HashMap<String, DataSource>();

    public static void init(String configDirectory) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            File inputFile = new File(configDirectory, XML_FILENAME);
            Document document = builder.parse(inputFile);
            Element root = document.getDocumentElement();
            NodeList list = root.getElementsByTagName(DATASOURCE_TAG);
            for (int i = 0; i < list.getLength(); ++i) {
                DataSource s = new DataSource((Element)list.item(i));
                templates.put(s.getName(), s);
            }
        }
        catch (Exception e) {
            MraldOutFile.logToFile(e);
        }
    }

    private JdbcTemplates() {
    }

    public static TreeSet<String> getTemplateList() {
        return new TreeSet<String>(templates.keySet());
    }

    public static String getPort(String key) {
        return templates.get(key).getPort();
    }

    public static String getServerString(String key) {
        return templates.get(key).getServerString();
    }

    public static String getDriverClass(String key) {
        return templates.get(key).getDriverClass();
    }

    public static String getUrl(String key) {
        return templates.get(key).getUrl();
    }

    public static String getSchema(String key) {
        return templates.get(key).getSchema();
    }

    public static String getList() {
        StringBuilder ret = new StringBuilder("Datasources configured:");
        ret.append(Config.NEWLINE);
        for (DataSource s : templates.values()) {
            ret.append(Config.NEWLINE);
            ret.append(s.toString());
        }
        return ret.toString();
    }
}

