/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TableMetaData;

public class KeywordSearch
extends AbstractStep {
    protected String datasource;
    private MsgObject msg;

    public void execute(MsgObject msg) throws WorkflowStepException {
        this.msg = msg;
        try {
            String[] searchParams = msg.getValue("term");
            this.datasource = msg.getValue("Datasource")[0];
            PrintWriter out = msg.getOutPrintWriter();
            this.search(searchParams, out);
            out.write("\n");
            out.close();
        }
        catch (MraldException me) {
            throw new WorkflowStepException(me);
        }
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public void search(String[] searchParams, Writer out) throws MraldException {
        try {
            Connection conn = new MraldConnection(this.datasource, this.msg).getConnection();
            if (searchParams.length < 1) {
                out.write("\nYou must enter a search criteria.\n");
                return;
            }
            DBMetaData md = MetaData.getDbMetaData(this.datasource);
            Collection<TableMetaData> tableMetaData = md.getAllTableMetaData();
            for (TableMetaData tableInfo : tableMetaData) {
                out.write("\nChecking: " + tableInfo.getName() + "\n");
                if (tableInfo.getName().indexOf(searchParams[0]) != -1) {
                    out.write("\tTable name matches!\n");
                }
                Collection<String> fieldNames = tableInfo.getColumnNames();
                Iterator<String> iter2 = fieldNames.iterator();
                String whereClause = "";
                if (iter2 == null || !iter2.hasNext()) {
                    // empty if block
                }
                while (iter2.hasNext()) {
                    Integer type;
                    String field = iter2.next();
                    if (field.indexOf(searchParams[0]) != -1) {
                        out.write("\t" + field + " field name matches!\n");
                    }
                    if (FBUtils.isNumberType(type = tableInfo.getFieldType(field)) || FBUtils.isDateType(type) || FBUtils.isBooleanType(type)) continue;
                    whereClause = whereClause + field + " like '%" + searchParams[0] + "%' OR ";
                }
                if (whereClause.equals("")) {
                    out.flush();
                    continue;
                }
                whereClause = whereClause + "1=0";
                String query = "select * from " + tableInfo.getName() + " where " + whereClause;
                out.write("\trunning: " + query + "\n");
                out.flush();
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    out.write("\n\t");
                    for (int i = 0; i < fieldNames.size(); ++i) {
                        String value = rs.getString(i + 1);
                        if (value == null) continue;
                        out.write(value);
                        out.write("\t");
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new MraldException(e);
        }
        catch (IOException e) {
            throw new MraldException(e);
        }
    }
}

