/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mitre.mrald.control.WorkFlow;
import org.mitre.mrald.util.MraldParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParseXML {
    private static String ROOT_CHILD_TAG = "WfPath";
    private static String ROOT_TAG = "WorkFlow";
    private static String WF_METHOD_ORDER_ATTR = "Order";
    private static String WF_METHOD_TAG = "WfMethod";
    private static String WF_NAME_TAG = "WfName";
    private static String WF_OBJECT_NAME_TAG = "ObjectName";
    private static String WF_OBJECT_TAG = "WfObject";
    private String XMLFile = null;
    private String rootChildTag = ROOT_CHILD_TAG;
    private String rootTag = ROOT_TAG;
    private HashMap<Integer, Object> wfObjects = new HashMap();
    private String wfPathName = null;
    private String workFlowMethodOrder = WF_METHOD_ORDER_ATTR;
    private String workFlowMethodTag = WF_METHOD_TAG;
    private String workFlowNameTag = WF_NAME_TAG;
    private String workFlowObjectNameTag = WF_OBJECT_NAME_TAG;
    private String workFlowObjectTag = WF_OBJECT_TAG;

    public ParseXML(String sXMLFile) {
        this.XMLFile = sXMLFile;
    }

    public void setRootChildTag() {
        this.rootChildTag = ROOT_CHILD_TAG;
    }

    public void setRootTag() {
        this.rootTag = ROOT_TAG;
    }

    public void setWfNameTag() {
        this.workFlowNameTag = WF_NAME_TAG;
    }

    public void setWfObjectTag() {
        this.workFlowObjectTag = WF_OBJECT_TAG;
    }

    public void setWfPath(String workFlowPath) {
        this.wfPathName = workFlowPath;
    }

    public String getLocationString(SAXParseException saxE) {
        String slocation = "public id: " + saxE.getPublicId() + " line number: " + saxE.getLineNumber();
        return slocation;
    }

    public Node getNextElement(Node thisNode) throws MraldParseException {
        while (thisNode != null && thisNode.getNodeType() != 1) {
            thisNode = thisNode.getNextSibling();
        }
        if (thisNode == null) {
            MraldParseException parsingException = new MraldParseException("\n No more Element Nodes found");
            throw parsingException;
        }
        return thisNode;
    }

    public String getRootChildTag() {
        return this.rootChildTag;
    }

    public String getRootTag() {
        return this.rootTag;
    }

    public String getWfMethodTag() {
        return this.workFlowMethodTag;
    }

    public String getWfNameTag() {
        return this.workFlowNameTag;
    }

    public String getWfObjectTag() {
        return this.workFlowObjectTag;
    }

    public String getWfPath() {
        return this.wfPathName;
    }

    public Element getWorkFlowPath(Element workFlow) throws MraldParseException {
        NodeList nameList = workFlow.getElementsByTagName(this.workFlowNameTag);
        Node currentNode = workFlow;
        if (nameList.getLength() < 1 || nameList == null) {
            MraldParseException parsingException = new MraldParseException("\n The document is invalid. The required tag " + this.workFlowNameTag + " is not contained within " + this.getRootChildTag());
            throw parsingException;
        }
        if (nameList.getLength() > 1) {
            MraldParseException parsingException = new MraldParseException("\n The document is invalid. The node " + workFlow.getTagName() + " contains multiple names. ");
            throw parsingException;
        }
        if (!this.isWfPath(nameList.item(0).getFirstChild().getNodeValue())) {
            currentNode = this.getNextElement(nameList.item(0).getParentNode().getNextSibling());
            if (currentNode == null) {
                MraldParseException parsingException = new MraldParseException("\n Could not find the workflow path " + this.wfPathName + " in this XML document.");
                throw parsingException;
            }
            return this.getWorkFlowPath((Element)currentNode);
        }
        return (Element)nameList.item(0);
    }

    public boolean isWfPath(String workFlowPath) {
        return workFlowPath.equalsIgnoreCase(this.wfPathName);
    }

    public HashMap ProcessXML() throws IOException, DOMException, ParserConfigurationException, MraldParseException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(this.XMLFile);
            Element rootElement = document.getDocumentElement();
            String tagName = rootElement.getTagName();
            if (!rootElement.hasChildNodes()) {
                MraldParseException parsingException = new MraldParseException("\n The document is invalid. The node " + tagName + " does not contain any child nodes. ");
                throw parsingException;
            }
            Node childNode = rootElement.getFirstChild();
            if (!((Element)(childNode = this.getNextElement(childNode))).getTagName().equals(this.rootChildTag)) {
                System.out.println("RootChildTag: " + this.rootChildTag);
                MraldParseException parsingException = new MraldParseException("\n The document is invalid. The node " + ((Element)childNode).getTagName() + " is not a valid child Node for " + this.getRootTag());
                throw parsingException;
            }
            if (!childNode.hasChildNodes()) {
                MraldParseException parsingException = new MraldParseException("\n The document is invalid. The node " + tagName + " does not contain any child nodes. ");
                throw parsingException;
            }
            childNode = this.getWorkFlowPath((Element)childNode);
            this.processWorkFlow((Element)childNode);
            return this.wfObjects;
        }
        catch (SAXParseException spe) {
            spe.printStackTrace();
            MraldParseException parsingException = new MraldParseException("\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId() + spe.getMessage());
            if (spe.getException() != null) {
                // empty if block
            }
            throw parsingException;
        }
        catch (SAXException spe) {
            MraldParseException parsingException = new MraldParseException(spe.getMessage());
            if (spe.getException() != null) {
                // empty if block
            }
            throw parsingException;
        }
        catch (DOMException de) {
            throw de;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ParserConfigurationException pce) {
            throw pce;
        }
    }

    public void addWfObject(Object wfObject, Integer order) throws MraldParseException {
        this.wfObjects.put(order, wfObject);
    }

    public void processWorkFlow(Element workFlow) throws MraldParseException {
        NodeList workFlowObjects = ((Element)workFlow.getParentNode()).getElementsByTagName(this.getWfObjectTag());
        Node wfObjectNode = null;
        Node wfOrderNode = null;
        Integer Order = null;
        WorkFlow wfObject = new WorkFlow();
        if (workFlowObjects.getLength() < 1) {
            MraldParseException parsingException = new MraldParseException("No nodes for " + workFlow.getParentNode().getNodeName() + " of tag name " + this.getWfObjectTag());
            throw parsingException;
        }
        for (int k = 0; k < workFlowObjects.getLength(); ++k) {
            wfObjectNode = this.getNextElement(workFlowObjects.item(k).getFirstChild());
            if (!wfObjectNode.getNodeName().equalsIgnoreCase(this.workFlowObjectNameTag)) {
                MraldParseException parsingException = new MraldParseException("\nXML Document invalid. " + this.workFlowObjectNameTag + " is a required node for node " + workFlowObjects.item(k).getNodeName());
                throw parsingException;
            }
            if (wfObjectNode.getFirstChild().getNodeType() != 3) {
                MraldParseException parsingException = new MraldParseException("\nXML Document invalid. Name is required for Object." + wfObjectNode.getNodeName());
                throw parsingException;
            }
            wfObject = new WorkFlow(wfObjectNode.getFirstChild().getNodeValue());
            this.processWorkFlowMethod(wfObject, wfObjectNode.getParentNode());
            wfOrderNode = this.getNextElement(wfObjectNode.getNextSibling());
            if (wfOrderNode.getFirstChild().getNodeType() != 3) {
                MraldParseException parsingException = new MraldParseException("\nXML Document invalid. Order is required for Object." + wfOrderNode.getNodeName());
                throw parsingException;
            }
            Order = new Integer(wfOrderNode.getFirstChild().getNodeValue());
            this.addWfObject(wfObject, Order);
        }
    }

    public void processWorkFlowMethod(WorkFlow thisWfObject, Node workFlowOrder) throws MraldParseException {
        NodeList workFlowMethods = ((Element)workFlowOrder).getElementsByTagName(this.getWfMethodTag());
        String methodName = null;
        Integer methodOrder = null;
        Element wfObject = null;
        if (workFlowMethods.getLength() < 1) {
            thisWfObject.setHasMethods(false);
            return;
        }
        thisWfObject.setHasMethods(true);
        for (int k = 0; k < workFlowMethods.getLength(); ++k) {
            wfObject = (Element)workFlowMethods.item(k);
            methodName = wfObject.getFirstChild().getNodeValue();
            methodOrder = new Integer(wfObject.getAttributeNode(this.workFlowMethodOrder).getValue());
            thisWfObject.addWfMethod(methodName, methodOrder);
        }
    }
}

