/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.mitre.mrald.util.TimeFormatException;

public class TimeFormatter {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORM_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    public static final String ORACLE_SQL_TIME_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    public static final String ORACLE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String SYBASE_SQL_TIME_FORMAT = "mon dd yyyy hh:mm AM";
    public static final String SYBASE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static String getTimeAsString(Calendar thisTime) {
        SimpleDateFormat thisDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return thisDateFormat.format(thisTime.getTime());
    }

    public static boolean isValid(String dateTime) {
        String[] dateTimeParts = dateTime.split(" ");
        String[] dateParts = dateTimeParts[0].split("[/-]");
        if (dateParts.length != 3) {
            return false;
        }
        if (!(dateParts[0].matches("[1-9]|1[012]|0[1-9]") && dateParts[1].matches("[1-9]|[0123]\\d") && dateParts[2].matches("\\d{2}|\\d{4}"))) {
            return false;
        }
        String[] timePart = null;
        return dateTimeParts.length != 2 || (timePart = dateTimeParts[1].split(":")).length >= 2 && timePart.length <= 3;
    }

    public static Object formatDateTime(String date, boolean bReturnCal) throws TimeFormatException {
        GregorianCalendar cal;
        TimeFormatException thisException = new TimeFormatException("Invalid date format: " + date + ". Please reenter date.  The expected formats are month/day/year.  If you entered a time, the format should be either hour:minute, or hour:minute:second.");
        boolean validDate = TimeFormatter.isValid(date = date.trim());
        if (!validDate) {
            throw thisException;
        }
        String[] stringParts = date.split("[-/ :]");
        int[] intParts = new int[stringParts.length];
        for (int i = 0; i < stringParts.length; ++i) {
            intParts[i] = Integer.parseInt(stringParts[i]);
        }
        switch (stringParts.length) {
            case 3: {
                cal = new GregorianCalendar(intParts[2], intParts[0] - 1, intParts[1]);
                break;
            }
            case 5: {
                cal = new GregorianCalendar(intParts[2], intParts[0] - 1, intParts[1], intParts[3], intParts[4]);
                break;
            }
            case 6: {
                cal = new GregorianCalendar(intParts[2], intParts[0] - 1, intParts[1], intParts[3], intParts[4], intParts[5]);
                break;
            }
            default: {
                throw thisException;
            }
        }
        if (bReturnCal) {
            return cal;
        }
        return TimeFormatter.formatPattern(cal);
    }

    private static String formatPattern(Calendar cal) throws TimeFormatException {
        SimpleDateFormat formatter = new SimpleDateFormat();
        formatter.applyPattern("yyyy-MM-dd HH:mm:ss");
        return formatter.format(cal.getTime());
    }
}

