/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Random;
import javax.servlet.http.Cookie;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.Mailer;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.MraldCrypter;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.User;

public class UserRegistration
extends AbstractStep {
    protected String username;
    protected String password;
    protected String pageurl;
    protected String loginAction;
    protected User mraldUser;
    protected final String USER_EXISTS = "AlreadyExists";
    protected FailReason errCode = null;

    public void execute(MsgObject msgObject) throws WorkflowStepException {
        try {
            this.username = msgObject.getValue("userName")[0];
            this.password = msgObject.getValue("password")[0];
            this.pageurl = msgObject.getValue("pageurl")[0];
            this.loginAction = msgObject.getValue("loginAction")[0];
            this.mraldUser = new User(this.username);
            if (this.loginAction.equals("addUser")) {
                String verifyPassword = msgObject.getReq().getParameter("verifyPassword");
                if (!this.password.equals(verifyPassword)) {
                    this.errCode = FailReason.PasswordMismatch;
                    WorkflowStepException npe = new WorkflowStepException("Your passwords did not match. Please go back and enter matching passwords.");
                    throw npe;
                }
                String[] regInfo = new String[]{msgObject.getReq().getParameter("firstName"), msgObject.getReq().getParameter("lastName"), msgObject.getReq().getParameter("company"), msgObject.getReq().getParameter("department"), msgObject.getReq().getParameter("address"), msgObject.getReq().getParameter("city"), msgObject.getReq().getParameter("state"), msgObject.getReq().getParameter("zip"), msgObject.getReq().getParameter("country")};
                try {
                    if (!this.registerUserInfo(this.password, verifyPassword, regInfo)) {
                        throw new WorkflowStepException("Error in Registering User. Please contact System Administrator.");
                    }
                }
                catch (SQLException sqe) {
                    try {
                        if (!MraldConnection.createPeopleTable()) {
                            this.errCode = FailReason.CantCreatePeopleTable;
                            throw new WorkflowStepException("Error in Registering User. Please contact System Administrator.", sqe);
                        }
                        if (!this.registerUserInfo(this.password, verifyPassword, regInfo)) {
                            throw new WorkflowStepException("Error in Registering User. Please contact System Administrator.", sqe);
                        }
                    }
                    catch (SQLException sqe2) {
                        throw new WorkflowStepException(sqe);
                    }
                }
                User mraldUser = new User(this.username);
                mraldUser.setEmail(this.username.toLowerCase());
                mraldUser.setTypeId(1);
                mraldUser.setGroup("Public");
                msgObject.getReq().getSession().setAttribute(Config.getProperty("cookietag"), null);
                msgObject.getReq().getSession().setAttribute(Config.getProperty("cookietag"), (Object)mraldUser);
                Cookie c = new Cookie(Config.getProperty("cookietag"), this.username);
                c.setMaxAge(0x3FFFFFFF);
                msgObject.getRes().addCookie(c);
            } else if (this.loginAction.equals("validateUser")) {
                String key = msgObject.getReq().getParameter("key");
                if (key == null || key.equals(null) || key.equals("null") || key.equals("")) {
                    this.errCode = FailReason.ValidationFailureNoKey;
                    throw new WorkflowStepException("No Validation Key Provided.  unable to Authenicate Your Identity.");
                }
                this.confirmUserInfo(key);
            } else {
                this.errCode = FailReason.InvalidAction;
                throw new WorkflowStepException("Invalid Entry Point.  Please go to " + Config.getProperty("BaseUrl") + "/MraldLogin.jsp and log in through a valid entry point.");
            }
            if (this.loginAction.equals("validateUser")) {
                msgObject.getRes().sendRedirect("ValidationSuccess.jsp");
            } else if (this.pageurl == null || this.pageurl.equals(null) || this.pageurl.equals("") || this.pageurl.equals("null")) {
                msgObject.getRes().sendRedirect(Config.getProperty("URL"));
            } else {
                msgObject.getRes().sendRedirect(this.pageurl);
            }
        }
        catch (WorkflowStepException e) {
            if (this.errCode != null) {
                this.niceErrorPage(msgObject);
            }
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowStepException(e);
        }
    }

    protected void niceErrorPage(MsgObject msgObject) {
        String message;
        switch (this.errCode) {
            case AlreadyExists: {
                message = "A user with that email address already exists.  Please use the browser back button and use a different email address`1, or you may request a new password <a href=\"RetrievePassword.jsp\">here</a>.";
                break;
            }
            case PasswordMismatch: {
                message = "The passwords provided did not match.  Please use the browser back button and try again.";
                break;
            }
            case CantCreatePeopleTable: {
                message = "Unable to properly set up the administrative database.  Please report this to the system administrator.";
                break;
            }
            case InvalidAction: {
                message = "An invalide action was requested by the calling page.  Please report this to the system administrator.";
                break;
            }
            case ValidationFailureNoKey: {
                message = "A validation key must be provided.  ";
                break;
            }
            case ValidationFailureBadKey: {
                message = "The validation key provided did not match the exptected value.  Please check your input for typos and try again.";
                break;
            }
            case UserDeleted: {
                message = "The user you are trying to validate for no longer exists.  Please re-register <a href=\"RegistrationForm.jsp\">here</a>.";
                break;
            }
            default: {
                message = "";
            }
        }
        try {
            msgObject.getReq().getSession().setAttribute("responseMessage", (Object)message);
            msgObject.getRes().sendRedirect("responseMessage.jsp");
        }
        catch (IOException e) {
            throw new MraldError(e, msgObject);
        }
    }

    protected void confirmUserInfo(String key) throws SQLException, ClassNotFoundException, NoSuchAlgorithmException, IOException, NullPointerException, Exception {
        MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
        String query = "SELECT * FROM people WHERE people.email = '" + this.username.toLowerCase() + "'";
        ResultSet r = conn.executeQuery(query);
        if (r.next()) {
            String newHash = this.password + ":" + r.getString("validationcode");
            if (!MraldCrypter.matchPassword(key, newHash)) {
                this.errCode = FailReason.ValidationFailureBadKey;
                r.close();
                conn.close();
                throw new WorkflowStepException("Validation Key Is Invalid. Please Try Again.");
            }
        } else {
            this.errCode = FailReason.UserDeleted;
            r.close();
            conn.close();
            throw new WorkflowStepException("No Username Available for Validation. Please Try Again Later.");
        }
        String update = "UPDATE people SET validated = 'Y' WHERE email = '" + this.username.toLowerCase() + "'";
        conn.executeUpdate(update);
        this.generateWelcome(this.username.toLowerCase());
        r.close();
        conn.close();
    }

    protected boolean registerUserInfo(String newpassword, String checkpassword, String[] regInfo) throws SQLException, ClassNotFoundException, NoSuchAlgorithmException, UnsupportedEncodingException, Exception {
        String peopleId = this.addUserInfo();
        if (peopleId == "AlreadyExists") {
            this.errCode = FailReason.AlreadyExists;
            return false;
        }
        String validationKey = this.generateKey();
        String hashKey = this.generateHash(validationKey);
        this.addRegInfo(peopleId, regInfo, validationKey);
        return true;
    }

    protected String addUserInfo() throws SQLException, ClassNotFoundException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
        String checkDup = "SELECT * FROM people WHERE email = '</email/>'";
        ResultSet rs = conn.executeQuery(checkDup = MiscUtils.replace(checkDup, "</email/>", this.username.toLowerCase()));
        if (rs.next()) {
            return "AlreadyExists";
        }
        String insert = "INSERT INTO people ( email, peopletypeid, latticegroupid, password) VALUES ('</email/>',  1, '</latticegroupid/>', '</password/>')";
        String passEncrypt = MraldCrypter.encodePassword(this.password, null);
        String newCOI = this.findCOI();
        insert = MiscUtils.replace(insert, "</email/>", this.username.toLowerCase());
        insert = MiscUtils.replace(insert, "</password/>", passEncrypt);
        insert = MiscUtils.replace(insert, "</latticegroupid/>", newCOI);
        long startTime = System.currentTimeMillis();
        conn.executeUpdate(insert);
        MiscUtils.logQueryRun(startTime, new StringBuffer());
        this.mraldUser.setEmail(this.username.toLowerCase());
        this.mraldUser.setTypeId(1);
        this.mraldUser.setGroup(newCOI);
        rs.close();
        conn.close();
        return this.username.toLowerCase();
    }

    protected void addRegInfo(String peopleId, String[] regInfo, String validationKey) throws SQLException, ClassNotFoundException {
        MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
        String insert = "UPDATE people SET firstName = '</firstName/>',  lastName = '</lastName/>', company = '</company/>', department = '</department/>', address = '</address/>', city = '</city/>', state = '</state/>', zip = '</zip/>', country = '</country/>', validated = 'N', validationcode = '</validationcode/>' WHERE email = '" + peopleId + "'";
        insert = MiscUtils.replace(insert, "</firstName/>", regInfo[0]);
        insert = MiscUtils.replace(insert, "</lastName/>", regInfo[1]);
        insert = MiscUtils.replace(insert, "</company/>", regInfo[2]);
        insert = MiscUtils.replace(insert, "</department/>", regInfo[3]);
        insert = MiscUtils.replace(insert, "</address/>", regInfo[4]);
        insert = MiscUtils.replace(insert, "</city/>", regInfo[5]);
        insert = MiscUtils.replace(insert, "</state/>", regInfo[6]);
        insert = MiscUtils.replace(insert, "</zip/>", regInfo[7]);
        insert = MiscUtils.replace(insert, "</country/>", regInfo[8]);
        insert = MiscUtils.replace(insert, "</validationcode/>", validationKey);
        conn.executeUpdate(insert);
        conn.close();
    }

    protected String findCOI() throws SQLException, ClassNotFoundException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
        String query = "SELECT DISTINCT latticegroupid FROM people WHERE people.email LIKE '%" + this.username.toLowerCase() + "%'";
        ResultSet rs = conn.executeQuery(query);
        String return_str = rs.next() ? rs.getString("latticegroupid") : "Public";
        rs.close();
        conn.close();
        return return_str;
    }

    protected String generateKey() {
        String key = "";
        Random rng = new Random(Calendar.getInstance().getTimeInMillis());
        for (int i = 0; i < 12; ++i) {
            key = key + (char)(rng.nextInt(26) + 97);
        }
        return key;
    }

    protected String generateHash(String key) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return MraldCrypter.encodePassword(this.password + ":" + key, null);
    }

    protected void generateConfirmation(String username, String key) throws NullPointerException, ClassNotFoundException, UnsupportedEncodingException, Exception {
        String newkey = URLEncoder.encode(key, "UTF-8");
        StringBuffer emailText = new StringBuffer();
        emailText.append("Thank you for registering with " + Config.getProperty("TITLE") + " system.\n\n");
        emailText.append("This email has been sent from " + Config.getProperty("BaseUrl") + "\n\n");
        emailText.append("You have received this email because this email address\n");
        emailText.append("was used during registration for our system.\n");
        emailText.append("If you did not register for our system, please disregard this\n");
        emailText.append("email. You do not need to unsubscribe or take any further action.\n\n");
        emailText.append("------------------------------------------------\n");
        emailText.append("Activation Instructions\n");
        emailText.append("------------------------------------------------\n\n");
        emailText.append("Thank you for registering.\n");
        emailText.append("We require that you 'validate' your registration to ensure that\n");
        emailText.append("the email address you entered was correct. This protects against\n");
        emailText.append("unwanted spam and malicious abuse.\n\n");
        emailText.append("To activate your account, simply click on the following link and\n");
        emailText.append("follow the instructions:\n\n");
        emailText.append(Config.getProperty("BaseUrl") + "/activate.jsp?key=" + newkey + "\n\n");
        emailText.append("(AOL Email users may need to cut and paste the link into your web browser).\n\n");
        emailText.append("------------------------------------------------\n");
        emailText.append("Not working?\n");
        emailText.append("------------------------------------------------\n\n");
        emailText.append("If you could not validate your registration by clicking on the link, please\n");
        emailText.append("visit this page:\n\n");
        emailText.append(Config.getProperty("BaseUrl") + "/activate.jsp\n\n");
        emailText.append("It will ask you to log in with your registered username, password,\n");
        emailText.append("and your validation key, which is provided below:\n\n");
        emailText.append("Validation Key: " + key + "\n\n");
        emailText.append("Please cut and paste, or type those numbers into the corresponding fields in the form.\n\n");
        emailText.append("If you still cannot validate your account, it's possible that the account has been removed.\n");
        emailText.append("If this is the case, please contact an administrator to rectify the problem.\n\n");
        emailText.append("Thank you for registering!\n\n");
        emailText.append("Regards,\n\n");
        emailText.append("The " + Config.getProperty("TITLE") + " Development Team\n");
        emailText.append(Config.getProperty("BaseUrl") + "\n\n");
        Mailer.send(username, Config.getProperty("MAILTO"), Config.getProperty("SMTPHOST"), emailText.toString(), "Account Activation");
    }

    protected void generateWelcome(String username) throws NullPointerException, ClassNotFoundException, Exception {
        StringBuffer emailText = new StringBuffer();
        emailText.append("Congratulations!\n\n");
        emailText.append("You have successfully completed the registration\n");
        emailText.append("process with our " + Config.getProperty("TITLE") + " system.  We just wanted to point\n");
        emailText.append("out a few things we thought you would notice and want to\n");
        emailText.append("reduce any confusion.\n\n");
        emailText.append("If this system currently has a lattice-based security model,\n");
        emailText.append("it will limit the access and availabilty of the data in\n");
        emailText.append("our site. Unless you were previously authorized by a Data\n");
        emailText.append("Owner, you will be assigned a 'PUBLIC' tag which provides\n");
        emailText.append("the least amount of access to the system.  If you are associated\n");
        emailText.append("with a specific lab or research project, please feel free to send\n");
        emailText.append("an email to the Site Administrator at " + Config.getProperty("MAILTO") + "\n\n");
        emailText.append("If you have further questions, please refer to our User's Guide\n");
        emailText.append("or spend some time exploring our system.\n\n");
        emailText.append("Thank you!\n\n");
        emailText.append("Regards,\n\n");
        emailText.append("The " + Config.getProperty("TITLE") + " Development Team\n");
        emailText.append(Config.getProperty("BaseUrl") + "\n\n");
        Mailer.send(username, Config.getProperty("MAILTO"), Config.getProperty("SMTPHOST"), emailText.toString(), "Welcome to " + Config.getProperty("TITLE"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FailReason {
        AlreadyExists,
        PasswordMismatch,
        CantCreatePeopleTable,
        InvalidAction,
        ValidationFailureNoKey,
        ValidationFailureBadKey,
        UserDeleted;

    }
}

