/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxbri;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis2.util.SchemaUtil;
import org.apache.axis2.util.URLProcessor;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CodeGenerationUtility {
    public static TypeMapper processSchemas(List schemas, Element[] additionalSchemas, CodeGenConfiguration cgconfig) throws RuntimeException {
        try {
            if (schemas == null || schemas.isEmpty()) {
                return new DefaultTypeMapper();
            }
            Vector<InputSource> xmlObjectsVector = new Vector<InputSource>();
            JavaTypeMapper mapper = new JavaTypeMapper();
            String baseURI = cgconfig.getBaseURI();
            for (int i = 0; i < schemas.size(); ++i) {
                XmlSchema schema = (XmlSchema)schemas.get(i);
                InputSource inputSource = new InputSource(new StringReader(CodeGenerationUtility.getSchemaAsString(schema)));
                inputSource.setSystemId(baseURI);
                xmlObjectsVector.add(inputSource);
            }
            File outputDir = new File(cgconfig.getOutputLocation(), "src");
            outputDir.mkdir();
            Map nsMap = cgconfig.getUri2PackageNameMap();
            for (int i = 0; i < xmlObjectsVector.size(); ++i) {
                SchemaCompiler sc = XJC.createSchemaCompiler();
                XmlSchema schema = (XmlSchema)schemas.get(i);
                String pkg = null;
                if (nsMap != null) {
                    pkg = (String)nsMap.get(schema.getTargetNamespace());
                }
                if (pkg == null) {
                    pkg = CodeGenerationUtility.extractNamespace(schema);
                }
                sc.setDefaultPackageName(pkg);
                sc.parseSchema((InputSource)xmlObjectsVector.elementAt(i));
                S2JJAXBModel jaxbModel = sc.bind();
                JCodeModel codeModel = jaxbModel.generateCode(null, null);
                FileCodeWriter writer = new FileCodeWriter(outputDir);
                codeModel.build((CodeWriter)writer);
                Collection mappings = jaxbModel.getMappings();
                Iterator iter = mappings.iterator();
                while (iter.hasNext()) {
                    Mapping mapping = (Mapping)iter.next();
                    QName qn = mapping.getElement();
                    String typeName = mapping.getType().getTypeClass().fullName();
                    mapper.addTypeMappingName(qn, typeName);
                }
            }
            return mapper;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractNamespace(XmlSchema schema) {
        String pkg = schema.getTargetNamespace();
        if (pkg == null) {
            XmlSchema[] schemas2 = SchemaUtil.getAllSchemas((XmlSchema)schema);
            for (int j = 0; schemas2 != null && j < schemas2.length && (pkg = schemas2[j].getTargetNamespace()) == null; ++j) {
            }
        }
        if (pkg == null) {
            pkg = "org.apache.axis2";
        }
        pkg = URLProcessor.makePackageName((String)pkg);
        return pkg;
    }

    private static String getSchemaAsString(XmlSchema schema) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        schema.write((OutputStream)baos);
        return baos.toString();
    }
}

