/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.MultirefHelper;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.util.StreamWrapper;
import org.apache.ws.java2wsdl.utils.TypeTable;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class BeanUtil {
    private static int nsCount = 1;

    public static XMLStreamReader getPullParser(Object beanObject, QName beanName, TypeTable typeTable, boolean qualified) {
        try {
            JamServiceFactory factory = JamServiceFactory.getInstance();
            JamServiceParams jam_service_parms = factory.createServiceParams();
            jam_service_parms.addClassLoader(beanObject.getClass().getClassLoader());
            jam_service_parms.includeClass(beanObject.getClass().getName());
            JamService service = factory.createService(jam_service_parms);
            JamClassIterator jClassIter = service.getClasses();
            if (!jClassIter.hasNext()) {
                throw new AxisFault("No service class found , exception from JAM");
            }
            JClass jClass = (JClass)jClassIter.next();
            QName elemntNameSpace = null;
            if (typeTable != null && qualified) {
                QName qNamefortheType = typeTable.getQNamefortheType(beanObject.getClass().getName());
                elemntNameSpace = new QName(qNamefortheType.getNamespaceURI(), "elementName");
            }
            Object[] properties = jClass.getDeclaredProperties();
            Arrays.sort(properties);
            BeanInfo beanInfo = Introspector.getBeanInfo(beanObject.getClass());
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> propertMap = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor propDesc = propDescs[i];
                propertMap.put(propDesc.getName(), propDesc);
            }
            ArrayList<Object> object = new ArrayList<Object>();
            for (int i = 0; i < properties.length; ++i) {
                Object o;
                int j;
                Object value;
                Object property = properties[i];
                PropertyDescriptor propDesc = (PropertyDescriptor)propertMap.get(BeanUtil.getCorrectName(property.getSimpleName()));
                if (propDesc == null) continue;
                Class<?> ptype = propDesc.getPropertyType();
                if (propDesc.getName().equals("class")) continue;
                if (SimpleTypeMapper.isSimpleType(ptype)) {
                    value = propDesc.getReadMethod().invoke(beanObject, null);
                    if (elemntNameSpace != null) {
                        object.add(new QName(elemntNameSpace.getNamespaceURI(), propDesc.getName(), elemntNameSpace.getPrefix()));
                    } else {
                        object.add(new QName(beanName.getNamespaceURI(), propDesc.getName(), beanName.getPrefix()));
                    }
                    object.add(value == null ? null : SimpleTypeMapper.getStringValue(value));
                    continue;
                }
                if (ptype.isArray()) {
                    if (SimpleTypeMapper.isSimpleType(ptype.getComponentType())) {
                        value = propDesc.getReadMethod().invoke(beanObject, null);
                        int i1 = Array.getLength(value);
                        for (j = 0; j < i1; ++j) {
                            o = Array.get(value, j);
                            if (elemntNameSpace != null) {
                                object.add(new QName(elemntNameSpace.getNamespaceURI(), propDesc.getName(), elemntNameSpace.getPrefix()));
                            } else {
                                object.add(new QName(beanName.getNamespaceURI(), propDesc.getName(), beanName.getPrefix()));
                            }
                            object.add(o == null ? null : SimpleTypeMapper.getStringValue(o));
                        }
                        continue;
                    }
                    value = (Object[])propDesc.getReadMethod().invoke(beanObject, null);
                    for (int j2 = 0; j2 < ((Object[])value).length; ++j2) {
                        Object o2 = value[j2];
                        if (elemntNameSpace != null) {
                            object.add(new QName(elemntNameSpace.getNamespaceURI(), propDesc.getName(), elemntNameSpace.getPrefix()));
                        } else {
                            object.add(new QName(beanName.getNamespaceURI(), propDesc.getName(), beanName.getPrefix()));
                        }
                        object.add(o2);
                    }
                    continue;
                }
                if (SimpleTypeMapper.isArrayList(ptype)) {
                    value = propDesc.getReadMethod().invoke(beanObject, null);
                    ArrayList objList = (ArrayList)value;
                    if (objList == null || objList.size() <= 0) continue;
                    for (j = 0; j < objList.size(); ++j) {
                        o = objList.get(j);
                        if (SimpleTypeMapper.isSimpleType(o)) {
                            if (elemntNameSpace != null) {
                                object.add(new QName(elemntNameSpace.getNamespaceURI(), propDesc.getName(), elemntNameSpace.getPrefix()));
                            } else {
                                object.add(new QName(beanName.getNamespaceURI(), propDesc.getName(), beanName.getPrefix()));
                            }
                            object.add(o);
                            continue;
                        }
                        if (elemntNameSpace != null) {
                            object.add(new QName(elemntNameSpace.getNamespaceURI(), propDesc.getName(), elemntNameSpace.getPrefix()));
                        } else {
                            object.add(new QName(beanName.getNamespaceURI(), propDesc.getName(), beanName.getPrefix()));
                        }
                        object.add(o);
                    }
                    continue;
                }
                if (elemntNameSpace != null) {
                    object.add(new QName(elemntNameSpace.getNamespaceURI(), propDesc.getName(), elemntNameSpace.getPrefix()));
                } else {
                    object.add(new QName(beanName.getNamespaceURI(), propDesc.getName(), beanName.getPrefix()));
                }
                value = propDesc.getReadMethod().invoke(beanObject, null);
                object.add(value);
            }
            return new ADBXMLStreamReaderImpl(beanName, object.toArray(), null, typeTable, qualified);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static XMLStreamReader getPullParser(Object beanObject) {
        String className = beanObject.getClass().getName();
        if (className.indexOf(".") > 0) {
            className = className.substring(className.lastIndexOf(46) + 1, className.length());
        }
        return BeanUtil.getPullParser(beanObject, new QName(className), null, false);
    }

    public static Object deserialize(Class beanClass, OMElement beanElement, ObjectSupplier objectSupplier, String arrayLocalName) throws AxisFault {
        try {
            if (beanClass.isArray()) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                Class<?> arrayClassType = beanClass.getComponentType();
                Iterator parts = beanElement.getChildElements();
                while (parts.hasNext()) {
                    Object obj;
                    OMElement omElement;
                    Object objValue = parts.next();
                    if (!(objValue instanceof OMElement) || !arrayLocalName.equals((omElement = (OMElement)objValue).getLocalName()) || (obj = BeanUtil.deserialize(arrayClassType, omElement, objectSupplier, null)) == null) continue;
                    valueList.add(obj);
                }
                return ConverterUtil.convertToArray(arrayClassType, valueList);
            }
            if (SimpleTypeMapper.isSimpleType(beanClass)) {
                return SimpleTypeMapper.getSimpleTypeObject(beanClass, beanElement);
            }
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor proprty = propDescs[i];
                properties.put(proprty.getName(), proprty);
            }
            Object beanObj = objectSupplier.getObject(beanClass);
            boolean tuched = false;
            Iterator elements = beanElement.getChildren();
            while (elements.hasNext()) {
                OMElement parts;
                String partsLocalName;
                PropertyDescriptor prty;
                Object objValue = elements.next();
                if (!(objValue instanceof OMElement) || (prty = (PropertyDescriptor)properties.get(partsLocalName = (parts = (OMElement)objValue).getLocalName())) == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.equals("class")) continue;
                Object partObj = SimpleTypeMapper.isSimpleType(parameters) ? SimpleTypeMapper.getSimpleTypeObject(parameters, parts) : (SimpleTypeMapper.isArrayList(parameters) ? SimpleTypeMapper.getArrayList((OMElement)parts.getParent(), prty.getName()) : (parameters.isArray() ? BeanUtil.deserialize(parameters, (OMElement)parts.getParent(), objectSupplier, prty.getName()) : BeanUtil.deserialize(parameters, parts, objectSupplier, null)));
                Object[] parms = new Object[]{partObj};
                prty.getWriteMethod().invoke(beanObj, parms);
                tuched = true;
            }
            if (tuched) {
                return beanObj;
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
    }

    public static Object deserialize(Class beanClass, OMElement beanElement, MultirefHelper helper, ObjectSupplier objectSupplier) throws AxisFault {
        Object beanObj;
        try {
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor proprty = propDescs[i];
                properties.put(proprty.getName(), proprty);
            }
            beanObj = objectSupplier.getObject(beanClass);
            Iterator elements = beanElement.getChildren();
            while (elements.hasNext()) {
                Object partObj;
                OMElement parts;
                String partsLocalName;
                PropertyDescriptor prty;
                Object child = elements.next();
                if (!(child instanceof OMElement) || (prty = (PropertyDescriptor)properties.get((partsLocalName = (parts = (OMElement)child).getLocalName()).toLowerCase())) == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.equals("class")) continue;
                OMAttribute attr = MultirefHelper.processRefAtt(parts);
                if (attr != null) {
                    String refId = MultirefHelper.getAttvalue(attr);
                    partObj = helper.getObject(refId);
                    if (partObj == null) {
                        partObj = helper.processRef(parameters, refId, objectSupplier);
                    }
                } else {
                    partObj = SimpleTypeMapper.getSimpleTypeObject(parameters, parts);
                    if (partObj == null) {
                        partObj = BeanUtil.deserialize(parameters, parts, objectSupplier, null);
                    }
                }
                Object[] parms = new Object[]{partObj};
                prty.getWriteMethod().invoke(beanObj, parms);
            }
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
        return beanObj;
    }

    public static Object[] deserialize(OMElement response, Object[] javaTypes, ObjectSupplier objectSupplier) throws AxisFault {
        int length = javaTypes.length;
        int count = 0;
        Object[] retObjs = new Object[length];
        Iterator parts = response.getChildren();
        MultirefHelper helper = new MultirefHelper((OMElement)response.getParent());
        while (parts.hasNext() && count < length) {
            Object objValue = parts.next();
            if (!(objValue instanceof OMElement)) continue;
            OMElement omElement = (OMElement)objValue;
            String currentLocalName = omElement.getLocalName();
            Class classType = (Class)javaTypes[count];
            omElement = BeanUtil.ProcessElement(classType, omElement, helper, parts, currentLocalName, retObjs, count, objectSupplier);
            while (omElement != null) {
                omElement = BeanUtil.ProcessElement((Class)javaTypes[++count], omElement, helper, parts, omElement.getLocalName(), retObjs, count, objectSupplier);
            }
            ++count;
        }
        for (int i = 0; i < length; ++i) {
            Class clazz = (Class)javaTypes[i];
            if (retObjs[i] != null || !clazz.isArray()) continue;
            retObjs[i] = Array.newInstance(clazz.getComponentType(), 0);
        }
        helper.clean();
        return retObjs;
    }

    private static OMElement ProcessElement(Class classType, OMElement omElement, MultirefHelper helper, Iterator parts, String currentLocalName, Object[] retObjs, int count, ObjectSupplier objectSupplier) throws AxisFault {
        if (classType.isArray()) {
            boolean done = true;
            ArrayList<Object> valueList = new ArrayList<Object>();
            Class<?> arrayClassType = classType.getComponentType();
            if ("byte".equals(arrayClassType.getName())) {
                retObjs[count] = BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier);
                return null;
            }
            valueList.add(BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier));
            while (parts.hasNext()) {
                Object objValue = parts.next();
                if (!(objValue instanceof OMElement)) continue;
                omElement = (OMElement)objValue;
                if (!currentLocalName.equals(omElement.getLocalName())) {
                    done = false;
                    break;
                }
                Object o = BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier);
                valueList.add(o);
            }
            retObjs[count] = ConverterUtil.convertToArray(arrayClassType, valueList);
            if (!done) {
                return omElement;
            }
        } else {
            retObjs[count] = BeanUtil.processObject(omElement, classType, helper, false, objectSupplier);
        }
        return null;
    }

    public static Object processObject(OMElement omElement, Class classType, MultirefHelper helper, boolean isArrayType, ObjectSupplier objectSupplier) throws AxisFault {
        boolean hasRef = false;
        OMAttribute omatribute = MultirefHelper.processRefAtt(omElement);
        String ref = null;
        if (omatribute != null) {
            hasRef = true;
            ref = MultirefHelper.getAttvalue(omatribute);
        }
        if (OMElement.class.isAssignableFrom(classType)) {
            if (hasRef) {
                OMElement elemnt = helper.getOMElement(ref);
                if (elemnt == null) {
                    return helper.processOMElementRef(ref);
                }
                return elemnt;
            }
            return omElement;
        }
        if (hasRef) {
            if (helper.getObject(ref) != null) {
                return helper.getObject(ref);
            }
            return helper.processRef(classType, ref, objectSupplier);
        }
        OMAttribute attribute = omElement.getAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi"));
        if (attribute != null) {
            return null;
        }
        if (SimpleTypeMapper.isSimpleType(classType)) {
            if (isArrayType && "byte".equals(classType.getName())) {
                String value = omElement.getText();
                return Base64.decode((String)value);
            }
            return SimpleTypeMapper.getSimpleTypeObject(classType, omElement);
        }
        if (SimpleTypeMapper.isArrayList(classType)) {
            return SimpleTypeMapper.getArrayList(omElement);
        }
        return BeanUtil.deserialize(classType, omElement, objectSupplier, null);
    }

    public static OMElement getOMElement(QName opName, Object[] args, QName partName, boolean qualifed, TypeTable typeTable) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int argCount = 0;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                objects.add("item" + i);
                objects.add(arg);
                continue;
            }
            if (arg instanceof Object[]) {
                Object[] array = (Object[])arg;
                for (int j = 0; j < array.length; ++j) {
                    Object o = array[j];
                    if (o == null) {
                        objects.add("item" + argCount);
                        objects.add(o);
                        continue;
                    }
                    if (SimpleTypeMapper.isSimpleType(o)) {
                        objects.add("item" + argCount);
                        objects.add(SimpleTypeMapper.getStringValue(o));
                        continue;
                    }
                    objects.add(new QName("item" + argCount));
                    if (o instanceof OMElement) {
                        OMElement wrappingElement;
                        OMFactory fac = OMAbstractFactory.getOMFactory();
                        if (partName == null) {
                            wrappingElement = fac.createOMElement("item" + argCount, null);
                            wrappingElement.addChild((OMNode)((OMElement)o));
                        } else {
                            wrappingElement = fac.createOMElement(partName, null);
                            wrappingElement.addChild((OMNode)((OMElement)o));
                        }
                        objects.add(wrappingElement);
                        continue;
                    }
                    objects.add(o);
                }
            } else if (SimpleTypeMapper.isSimpleType(arg)) {
                if (partName == null) {
                    objects.add("arg" + argCount);
                } else {
                    objects.add(partName);
                }
                objects.add(SimpleTypeMapper.getStringValue(arg));
            } else {
                if (partName == null) {
                    objects.add(new QName("arg" + argCount));
                } else {
                    objects.add(partName);
                }
                if (arg instanceof OMElement) {
                    OMElement wrappingElement;
                    OMFactory fac = OMAbstractFactory.getOMFactory();
                    if (partName == null) {
                        wrappingElement = fac.createOMElement("arg" + argCount, null);
                        wrappingElement.addChild((OMNode)((OMElement)arg));
                    } else {
                        wrappingElement = fac.createOMElement(partName, null);
                        wrappingElement.addChild((OMNode)((OMElement)arg));
                    }
                    objects.add(wrappingElement);
                } else if (arg instanceof byte[]) {
                    objects.add(Base64.encode((byte[])((byte[])arg)));
                } else {
                    objects.add(arg);
                }
            }
            ++argCount;
        }
        ADBXMLStreamReaderImpl xr = new ADBXMLStreamReaderImpl(opName, objects.toArray(), null, typeTable, qualifed);
        StreamWrapper parser = new StreamWrapper((XMLStreamReader)xr);
        StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getSOAP11Factory(), (XMLStreamReader)parser);
        stAXOMBuilder.setDoDebug(true);
        return stAXOMBuilder.getDocumentElement();
    }

    public static String getUniquePrifix() {
        return "ns" + nsCount++;
    }

    public static String getUniquePrefix() {
        return "ns" + nsCount++;
    }

    private static String getCorrectName(String wrongName) {
        if (wrongName.length() > 1) {
            return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH) + wrongName.substring(1, wrongName.length());
        }
        return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH);
    }
}

