/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.auth.mechanism;

import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.columba.ristretto.auth.AuthenticationException;
import org.columba.ristretto.auth.AuthenticationMechanism;
import org.columba.ristretto.auth.AuthenticationServer;
import org.columba.ristretto.auth.mechanism.SaslWrapper;

public class CramMD5Mechanism
implements AuthenticationMechanism,
CallbackHandler {
    private static final Logger LOG = Logger.getLogger("org.columba.ristretto.auth.mechanism");
    private String username;
    private char[] password;
    SaslWrapper sasl;

    public void authenticate(AuthenticationServer server, String user, char[] password) throws IOException, AuthenticationException {
        this.username = user;
        this.password = password;
        try {
            this.sasl = new SaslWrapper();
            this.sasl.createClient(new String[]{"CRAM-MD5"}, user, server.getService(), server.getHostName(), new Hashtable(), this);
            byte[] serverChallenge = server.authReceive();
            LOG.fine(new String(serverChallenge));
            byte[] response = this.sasl.evaluateChallenge(serverChallenge);
            LOG.fine(new String(response));
            server.authSend(response);
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new AuthenticationException(e.getCause());
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        LOG.info(toc.getMessage());
                        break;
                    }
                    case 2: {
                        LOG.severe(toc.getMessage());
                        break;
                    }
                    case 1: {
                        LOG.warning(toc.getMessage());
                        break;
                    }
                    default: {
                        LOG.fine(toc.getMessage());
                        break;
                    }
                }
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.password);
                continue;
            }
            if (this.sasl.handle(callbacks[i])) continue;
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

