/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.coder;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64EncoderInputStream
extends FilterInputStream {
    private static final byte[] table = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private byte[] outBytes = new byte[4];
    private byte[] inBytes = new byte[3];
    private int blockCount;
    private int pos;
    private int available;

    public Base64EncoderInputStream(InputStream in) {
        super(in);
    }

    private int encodeNextPack() throws IOException {
        if (this.blockCount == 24) {
            this.outBytes[0] = 13;
            this.outBytes[1] = 10;
            this.blockCount = 0;
            return 2;
        }
        int read = this.in.read(this.inBytes);
        if (read == 3) {
            this.outBytes[0] = table[(byte)(0x3F & this.inBytes[0] >> 2)];
            this.outBytes[1] = table[(byte)(0x3F & this.inBytes[0] << 4 | 0xF & this.inBytes[1] >> 4)];
            this.outBytes[2] = table[(byte)(0x3F & this.inBytes[1] << 2 | 3 & this.inBytes[2] >> 6)];
            this.outBytes[3] = table[(byte)(0x3F & this.inBytes[2])];
            ++this.blockCount;
        } else if (read > 0) {
            this.outBytes[0] = table[(byte)(0x3F & this.inBytes[0] >> 2)];
            if (read == 2) {
                this.outBytes[1] = table[(byte)(0x3F & this.inBytes[0] << 4 | 0xF & this.inBytes[1] >> 4)];
                this.outBytes[2] = table[(byte)(0x3F & this.inBytes[1] << 2)];
                this.outBytes[3] = 61;
            } else {
                this.outBytes[1] = table[(byte)(0x3F & this.inBytes[0] << 4)];
                this.outBytes[2] = 61;
                this.outBytes[3] = 61;
            }
        } else {
            return -1;
        }
        return 4;
    }

    public int read() throws IOException {
        if (this.pos == this.available) {
            this.available = this.encodeNextPack();
            this.pos = 0;
        }
        if (this.available == -1) {
            return -1;
        }
        return this.outBytes[this.pos++];
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        for (int i = 0; i < arg2; ++i) {
            int next = this.read();
            if (next == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            arg0[arg1 + i] = (byte)next;
        }
        return arg2;
    }

    public int available() throws IOException {
        return (int)((double)this.in.available() * 1.33);
    }
}

