/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.coder;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class CharsetDecoderInputStream
extends FilterInputStream {
    private Charset charset;
    private CharsetDecoder decoder;
    private ByteBuffer inBytes;
    private CharBuffer outBytes;

    public CharsetDecoderInputStream(InputStream arg0, Charset charset) {
        super(arg0);
        this.charset = charset;
        this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.inBytes = ByteBuffer.allocate(5);
        this.outBytes = CharBuffer.allocate(1);
    }

    private int decodeNextChar() throws IOException {
        this.inBytes.clear();
        this.inBytes.limit(1);
        int read = this.in.read();
        if (read == -1) {
            return -1;
        }
        this.inBytes.put(0, (byte)read);
        this.outBytes.clear();
        CoderResult result = this.decoder.decode(this.inBytes, this.outBytes, this.in.available() == 0);
        while (this.outBytes.position() == 0) {
            read = this.in.read();
            if (read == -1) {
                return -1;
            }
            this.inBytes.limit(this.inBytes.limit() + 1);
            this.inBytes.put(this.inBytes.limit() - 1, (byte)read);
            this.outBytes.clear();
            result = this.decoder.decode(this.inBytes, this.outBytes, this.in.available() == 0);
        }
        return this.outBytes.position();
    }

    public int read() throws IOException {
        if (this.decodeNextChar() == -1) {
            return -1;
        }
        return this.outBytes.get(0);
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        for (int i = 0; i < arg2; ++i) {
            int next = this.read();
            if (next == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            arg0[arg1 + i] = (byte)next;
        }
        return arg2;
    }
}

