/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.coder;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.coder.Base64;
import org.columba.ristretto.coder.QuotedPrintable;

public class EncodedWord {
    private static final Logger LOG = Logger.getLogger("org.columba.ristretto.coder");
    public static final int QUOTED_PRINTABLE = 0;
    public static final int BASE64 = 1;
    private static final Pattern encodedWordPattern = Pattern.compile("=\\?([^?]+)\\?([bBqQ])\\?([^?]+)\\?=");
    private static final Pattern spacePattern = Pattern.compile("\\s*");
    private static final Pattern wordTokenizerPattern = Pattern.compile("\\b([^\\s]+[\\s]*)");
    private static final Pattern whitespacePattern = Pattern.compile(" ");

    public static StringBuffer decode(CharSequence input) {
        StringBuffer result = new StringBuffer(input.length());
        int lastMatchEnd = 0;
        Matcher matcher = encodedWordPattern.matcher(input);
        while (matcher.find()) {
            Charset charset;
            CharSequence inbetween = input.subSequence(lastMatchEnd, matcher.start());
            if (!spacePattern.matcher(inbetween).matches()) {
                result.append((Object)inbetween);
            }
            try {
                charset = Charset.forName(matcher.group(1));
            }
            catch (UnsupportedCharsetException e) {
                charset = Charset.forName(System.getProperty("file.encoding"));
            }
            char type = matcher.group(2).toLowerCase().charAt(0);
            String encodedPart = matcher.group(3);
            if (type == 'q') {
                encodedPart = encodedPart.replace('_', ' ');
                result.append((Object)QuotedPrintable.decode(encodedPart, charset));
            } else {
                result.append((Object)charset.decode(Base64.decode(encodedPart)));
            }
            lastMatchEnd = matcher.end();
        }
        result.append((Object)input.subSequence(lastMatchEnd, input.length()));
        return result;
    }

    public static StringBuffer encode(CharSequence input, Charset charset, int type) {
        StringBuffer result = new StringBuffer(input.length());
        LinkedList<int[]> words = new LinkedList<int[]>();
        String encodedWordPrototype = type == 0 ? "=?" + charset.displayName() + "?q?" : "=?" + charset.displayName() + "?b?";
        int maxLength = 75 - (encodedWordPrototype.length() + 2);
        Matcher matcher = wordTokenizerPattern.matcher(input);
        block0: while (matcher.find()) {
            String word = matcher.group(1);
            for (int i = 0; i < word.length(); ++i) {
                if (word.charAt(i) <= '\u007f') continue;
                words.add(new int[]{matcher.start(), matcher.end()});
                continue block0;
            }
        }
        if (words.size() == 0) {
            return result.append((Object)input);
        }
        Iterator it = words.iterator();
        int[] last = (int[])it.next();
        while (it.hasNext()) {
            int[] act = (int[])it.next();
            if (last[1] - last[0] + act[1] - act[0] <= maxLength && act[0] - last[1] < 10) {
                it.remove();
                last[1] = act[1];
                continue;
            }
            last = act;
        }
        it = words.iterator();
        int lastWordEnd = 0;
        while (it.hasNext()) {
            StringBuffer encodedPart;
            int[] act = (int[])it.next();
            CharSequence rawWord = input.subSequence(act[0], act[1]);
            if (type == 0) {
                Matcher wsMatcher = whitespacePattern.matcher(rawWord);
                rawWord = wsMatcher.replaceAll("_");
                encodedPart = QuotedPrintable.encode(rawWord, charset);
            } else {
                encodedPart = Base64.encode(charset.encode(CharBuffer.wrap(rawWord)));
            }
            result.append((Object)input.subSequence(lastWordEnd, act[0]));
            result.append(encodedWordPrototype);
            result.append((Object)encodedPart);
            result.append("?=");
            lastWordEnd = act[1];
        }
        result.append((Object)input.subSequence(lastWordEnd, input.length()));
        return result;
    }
}

