/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.coder;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuotedPrintable {
    private static final Logger LOG = Logger.getLogger("org.columba.ristretto.coder");
    private static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern packPattern = Pattern.compile("=([0-9a-fA-F\r][0-9a-fA-F\n])");

    public static CharSequence decode(CharSequence input, Charset charset) {
        ByteBuffer buffer = ByteBuffer.allocate(input.length());
        Matcher matcher = packPattern.matcher(input);
        int lastMatchEnd = 0;
        while (matcher.find()) {
            try {
                buffer.put(((Object)input.subSequence(lastMatchEnd, matcher.start())).toString().getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.severe(e.getMessage());
            }
            String group = matcher.group(1);
            if (!group.equals("\r\n")) {
                buffer.put((byte)Integer.parseInt(group, 16));
            }
            lastMatchEnd = matcher.end();
        }
        try {
            buffer.put(((Object)input.subSequence(lastMatchEnd, input.length())).toString().getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.severe(e.getMessage());
        }
        buffer.limit(buffer.position());
        buffer.rewind();
        return charset.decode(buffer);
    }

    public static StringBuffer encode(CharSequence input, Charset charset) {
        StringBuffer result = new StringBuffer(input.length());
        CharBuffer current = CharBuffer.allocate(1);
        int lineLength = 0;
        for (int i = 0; i < input.length(); ++i) {
            current.rewind();
            current.put(0, input.charAt(i));
            ByteBuffer decoded = charset.encode(current);
            while (decoded.remaining() != 0) {
                byte next = decoded.get();
                if ((next == 9 || next == 32) && lineLength != 74 && input.charAt(i + 1) != '\r' && input.charAt(i + 1) != '\n' || next >= 33 && next != 61 && next <= 126) {
                    result.append((char)next);
                    ++lineLength;
                } else if (next == 13) {
                    result.append("\r\n");
                    ++i;
                    lineLength = 0;
                } else {
                    if (lineLength > 71) {
                        result.append("=\r\n");
                        lineLength = 0;
                    }
                    result.append('=');
                    result.append(QuotedPrintable.toHexString(next));
                    lineLength += 3;
                }
                if (lineLength <= 74) continue;
                result.append("=\r\n");
                lineLength = 0;
            }
        }
        return result;
    }

    private static char[] toHexString(byte in) {
        char[] result = new char[2];
        int value = in < 0 ? 0x80 | 0x7F & in : in;
        int hi = value / 16;
        int lo = value % 16;
        result[0] = hexTable[hi];
        result[1] = hexTable[lo];
        return result;
    }
}

