/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.IOException;
import org.columba.ristretto.io.Source;

public class ByteBufferSource
implements Source {
    private byte[] source;
    private int start;
    private int end;
    private int pos;

    public ByteBufferSource(byte[] source) {
        this.source = source;
        this.pos = 0;
        this.start = 0;
        this.end = source.length;
    }

    public Source fromActualPosition() {
        ByteBufferSource subsource = new ByteBufferSource(this.source);
        subsource.start = this.start + this.pos;
        subsource.end = this.end;
        subsource.pos = 0;
        return subsource;
    }

    public int getPosition() {
        return this.pos;
    }

    public void seek(int position) throws IOException {
        this.pos = position;
    }

    public char next() throws IOException {
        byte value = this.source[this.start + this.pos++];
        int trueValue = (value & 0x80) + (value & 0x7F);
        return (char)trueValue;
    }

    public boolean isEOF() {
        return this.pos == this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public char charAt(int pos) {
        try {
            this.seek(pos);
            return this.next();
        }
        catch (IOException e) {
            e.printStackTrace();
            return '\u0000';
        }
    }

    public Source subSource(int start, int end) {
        ByteBufferSource subsource = new ByteBufferSource(this.source);
        subsource.start = this.start + start;
        subsource.end = this.start + end;
        subsource.pos = 0;
        return subsource;
    }

    public CharSequence subSequence(int start, int end) {
        return this.subSource(start, end);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.length());
        for (int i = 0; i < this.length(); ++i) {
            buffer.append(this.charAt(i));
        }
        return buffer.toString();
    }

    public void close() throws IOException {
        this.source = null;
    }

    public void deepClose() throws IOException {
        this.close();
    }
}

