/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.IOException;
import org.columba.ristretto.io.Source;

public class CharSequenceSource
implements Source {
    private CharSequence source;
    private int start;
    private int end;
    private int pos;

    public CharSequenceSource(CharSequence source) {
        this.source = source;
        this.pos = 0;
        this.start = 0;
        this.end = source.length();
    }

    public Source subSource(int start, int end) {
        CharSequenceSource subsource = new CharSequenceSource(this.source);
        subsource.start = this.start + start;
        subsource.end = this.start + end;
        subsource.pos = 0;
        return subsource;
    }

    public CharSequence subSequence(int start, int end) {
        return this.subSource(start, end);
    }

    public Source fromActualPosition() {
        CharSequenceSource subsource = new CharSequenceSource(this.source);
        subsource.start = this.start + this.pos;
        subsource.end = this.end;
        subsource.pos = 0;
        return subsource;
    }

    public int getPosition() {
        return this.pos;
    }

    public void seek(int position) throws IOException {
        this.pos = position;
    }

    public char next() throws IOException {
        return this.source.charAt(this.start + this.pos++);
    }

    public int length() {
        return this.end - this.start;
    }

    public char charAt(int arg0) {
        try {
            this.pos = arg0;
            return this.next();
        }
        catch (IOException e) {
            e.printStackTrace();
            return '\u0000';
        }
    }

    public String toString() {
        if (this.length() < 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(this.length());
        for (int i = 0; i < this.length(); ++i) {
            buffer.append(this.charAt(i));
        }
        return buffer.toString();
    }

    public boolean isEOF() {
        return this.pos == this.end;
    }

    public void close() throws IOException {
        this.source = null;
    }

    public void deepClose() throws IOException {
        this.close();
    }
}

