/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Timer;
import java.util.TimerTask;
import org.columba.ristretto.io.CloseChannelTimerTask;

public class FileSourceModel {
    private File file;
    private FileChannel channel;
    private ByteBuffer buffer;
    private int bufferStart;
    private int references;
    private CloseChannelTimerTask closeTask;
    private static Timer timer = new Timer();
    private static final int BUFFERSIZE = 61440;
    private static final long CLOSE_DELAY = 2000L;

    public FileSourceModel(File file) throws IOException {
        this.file = file;
        this.buffer = ByteBuffer.allocate(61440);
        this.bufferStart = 0;
        this.references = 0;
        this.updateBufferFromFile();
    }

    public char get(int pos) throws IOException {
        if (pos < this.bufferStart) {
            while (pos < this.bufferStart) {
                this.bufferStart -= 30720;
            }
            this.updateBufferFromFile();
        } else if (pos >= this.bufferStart + 61440) {
            while (pos >= this.bufferStart + 61440) {
                this.bufferStart += 30720;
            }
            this.updateBufferFromFile();
        }
        byte value = this.buffer.get(pos - this.bufferStart);
        int trueValue = (value & 0x80) + (value & 0x7F);
        return (char)trueValue;
    }

    private void updateBufferFromFile() throws IOException {
        if (this.channel == null) {
            this.channel = new RandomAccessFile(this.file, "r").getChannel();
        }
        this.buffer.clear();
        this.channel.read(this.buffer, this.bufferStart);
        this.restartCloseTimer();
    }

    private void restartCloseTimer() {
        if (this.closeTask != null) {
            this.closeTask.cancel();
        }
        this.closeTask = new CloseChannelTimerTask(this);
        timer.schedule((TimerTask)this.closeTask, 2000L);
    }

    public int length() throws IOException {
        return (int)this.channel.size();
    }

    public void incReferences() {
        ++this.references;
    }

    public void decReferences() {
        --this.references;
        if (this.references <= 0) {
            try {
                this.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public File getFile() {
        return this.file;
    }
}

