/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import org.columba.ristretto.concurrency.Mutex;

public class MemBuffer {
    private static final int INCREMENT = 1024;
    private byte[] buffer;
    private int len;
    private Mutex mutex;

    public MemBuffer() {
        this(1024);
    }

    public MemBuffer(int size) {
        this.buffer = new byte[size];
        this.len = 0;
        this.mutex = new Mutex();
    }

    public void append(int value) {
        this.mutex.lock();
        if (this.len == this.buffer.length) {
            this.growBuffer(this.buffer.length + 1024);
        }
        this.buffer[this.len++] = (byte)value;
        this.mutex.release();
    }

    public void append(byte[] array, int offset, int length) {
        this.mutex.lock();
        int available = this.buffer.length - this.len;
        if (length > available) {
            this.growBuffer(this.buffer.length + (length - available > 1024 ? length : 1024));
        }
        System.arraycopy(array, offset, this.buffer, this.len, length);
        this.len += length;
        this.mutex.release();
    }

    public void append(byte[] array) {
        this.append(array, 0, array.length);
    }

    public int get(int pos) {
        if (pos > this.len) {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
        return this.buffer[pos];
    }

    public int get(int pos, byte[] array) {
        return this.get(pos, array, 0, array.length);
    }

    public int get(int pos, byte[] array, int offset, int length) {
        int result;
        this.mutex.lock();
        int n = result = length > this.len - pos ? this.len - pos : length;
        if (result < 0) {
            this.mutex.release();
            throw new ArrayIndexOutOfBoundsException(pos);
        }
        System.arraycopy(this.buffer, pos, array, offset, result);
        this.mutex.release();
        return result;
    }

    public int size() {
        this.mutex.lock();
        int result = this.len;
        this.mutex.release();
        return result;
    }

    private void growBuffer(int newSize) {
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        this.buffer = newBuffer;
    }
}

