/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.IOException;
import java.io.InputStream;
import org.columba.ristretto.io.MemBuffer;

public class MemBufferInputStream
extends InputStream {
    private MemBuffer buffer;
    private int pos;

    public MemBufferInputStream(MemBuffer buffer) {
        this.buffer = buffer;
    }

    public int read() throws IOException {
        if (this.buffer.size() == this.pos) {
            return -1;
        }
        return this.buffer.get(this.pos++);
    }

    public int available() throws IOException {
        return this.buffer.size() - this.pos;
    }

    public void close() throws IOException {
        this.buffer = null;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.buffer.get(this.pos, b, off, len);
        this.pos += result;
        if (result == 0) {
            return -1;
        }
        return result;
    }

    public long skip(long n) throws IOException {
        this.pos = (int)((long)this.pos + n);
        return this.pos;
    }

    public MemBuffer getBuffer() {
        return this.buffer;
    }
}

