/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.log;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LogInputStream
extends FilterInputStream {
    private static final byte[] PREFIX_STRING = new byte[]{83, 58, 32};
    private static final int LINEEND = 0;
    private static final int IN_LINE = 1;
    private static final int MAX_LENGTH = 100 - PREFIX_STRING.length;
    private int state;
    private int line_length;
    private OutputStream logOutputStream;

    public LogInputStream(InputStream arg0, OutputStream log) {
        super(arg0);
        this.logOutputStream = log;
        this.state = 0;
        this.line_length = 0;
    }

    public LogInputStream(InputStream arg0) {
        this(arg0, System.out);
    }

    public int read() throws IOException {
        int read = this.in.read();
        if (read == -1) {
            return -1;
        }
        switch (this.state) {
            case 0: {
                this.line_length = 0;
                this.state = 1;
                this.logOutputStream.write(PREFIX_STRING);
                break;
            }
            case 1: {
                ++this.line_length;
                if (read == 10) {
                    this.state = 0;
                    break;
                }
                if (this.line_length != MAX_LENGTH) break;
                this.line_length = 0;
                this.logOutputStream.write(92);
                this.logOutputStream.write(10);
                this.logOutputStream.write(PREFIX_STRING);
            }
        }
        this.logOutputStream.write(read);
        return read;
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int next;
        int i;
        for (i = 0; i < arg2 && (next = this.read()) != -1; ++i) {
            arg0[arg1 + i] = (byte)next;
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    public OutputStream getLogOutputStream() {
        return this.logOutputStream;
    }

    public void setLogOutputStream(OutputStream logOutputStream) {
        this.logOutputStream = logOutputStream;
    }
}

