/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.columba.ristretto.parser.AddressParser;
import org.columba.ristretto.parser.ParserException;

public class Address
implements Serializable,
Comparable {
    private String displayName;
    private String mailAddress;
    static final long serialVersionUID = -7663098020871087578L;

    public Address(String mailAddress) {
        this("", mailAddress);
    }

    public Address(String displayName, String mailAddress) {
        this.displayName = displayName;
        this.mailAddress = mailAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMailAddress() {
        return this.mailAddress;
    }

    public String getCanonicalMailAddress() {
        return '<' + this.mailAddress + '>';
    }

    public String getShortAddress() {
        if (this.displayName != null && this.displayName.length() > 0) {
            return this.displayName;
        }
        return this.mailAddress;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 != null && arg0 instanceof Address) {
            Address a = (Address)arg0;
            result = true;
            if (this.mailAddress != null) {
                result = result && this.mailAddress.equals(a.getMailAddress());
            }
        }
        return result;
    }

    public String toString() {
        if (this.displayName == null || this.displayName.length() == 0) {
            return this.mailAddress;
        }
        return "\"" + this.displayName + "\" " + this.getCanonicalMailAddress();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.displayName != null) {
            out.writeByte(1);
            out.writeUTF(this.displayName);
            out.writeUTF(this.mailAddress);
        } else {
            out.writeByte(0);
            out.writeUTF(this.mailAddress);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte mode = in.readByte();
        if (mode == 1) {
            this.displayName = in.readUTF();
        }
        this.mailAddress = in.readUTF();
    }

    public int compareTo(Object arg0) {
        return this.mailAddress.compareTo(((Address)arg0).getMailAddress());
    }

    public int hashCode() {
        return this.mailAddress.hashCode();
    }

    public static Address parse(CharSequence source) throws ParserException {
        return AddressParser.parseAddress(source);
    }
}

