/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.columba.ristretto.message.Saveable;

public class Flags
implements Saveable,
Cloneable {
    public static final short ANSWERED = 1;
    public static final short DRAFT = 4;
    public static final short FLAGGED = 8;
    public static final short RECENT = 16;
    public static final short SEEN = 32;
    public static final short DELETED = 64;
    private short flags;

    public Flags() {
        this.flags = 0;
    }

    public Flags(short flags) {
        this.flags = flags;
    }

    public Flags(ObjectInputStream in) throws IOException {
        this.load(in);
    }

    public boolean get(short mask) {
        return (this.flags & mask) > 0;
    }

    public void set(short mask, boolean value) {
        if (value) {
            this.set(mask);
        } else {
            this.clear(mask);
        }
    }

    public void set(short mask) {
        this.flags = (short)(this.flags | mask);
    }

    public void clear(short mask) {
        this.flags = (short)(this.flags & (0xFFFFFFFF ^ mask));
    }

    public void toggle(short mask) {
        this.flags = (short)(this.flags ^ mask);
    }

    public boolean getSeen() {
        return this.get((short)32);
    }

    public boolean getRecent() {
        return this.get((short)16);
    }

    public boolean getAnswered() {
        return this.get((short)1);
    }

    public boolean getFlagged() {
        return this.get((short)8);
    }

    public boolean getDeleted() {
        return this.get((short)64);
    }

    public boolean getDraft() {
        return this.get((short)4);
    }

    public void setSeen(boolean b) {
        if (b) {
            this.set((short)32);
        } else {
            this.clear((short)32);
        }
    }

    public void setRecent(boolean b) {
        if (b) {
            this.set((short)16);
        } else {
            this.clear((short)16);
        }
    }

    public void setAnswered(boolean b) {
        if (b) {
            this.set((short)1);
        } else {
            this.clear((short)1);
        }
    }

    public void setFlagged(boolean b) {
        if (b) {
            this.set((short)8);
        } else {
            this.clear((short)8);
        }
    }

    public void setDeleted(boolean b) {
        if (b) {
            this.set((short)64);
        } else {
            this.clear((short)64);
        }
    }

    public void setDraft(boolean b) {
        if (b) {
            this.set((short)4);
        } else {
            this.clear((short)4);
        }
    }

    public void load(ObjectInputStream in) throws IOException {
        this.flags = in.readShort();
    }

    public void save(ObjectOutputStream out) throws IOException {
        out.writeShort(this.flags);
    }

    public Object clone() {
        try {
            Flags clone = (Flags)super.clone();
            clone.flags = this.flags;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short s) {
        this.flags = s;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj != null && obj instanceof Flags) {
            Flags other = (Flags)obj;
            isEqual = this.flags == other.flags;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.flags;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Flags[answered=");
        buffer.append(this.getAnswered());
        buffer.append(", draft=");
        buffer.append(this.getDraft());
        buffer.append(", expunged=");
        buffer.append(this.getDeleted());
        buffer.append(", flagged=");
        buffer.append(this.getFlagged());
        buffer.append(", recent=");
        buffer.append(this.getRecent());
        buffer.append(", seen=");
        buffer.append(this.getSeen());
        buffer.append("]");
        return buffer.toString();
    }
}

