/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.message;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.coder.EncodedWord;
import org.columba.ristretto.io.Streamable;
import org.columba.ristretto.message.Header;
import org.columba.ristretto.message.MimeType;
import org.columba.ristretto.parser.MimeTypeParser;
import org.columba.ristretto.parser.ParserException;

public class MimeHeader
implements Streamable {
    public static final int PLAIN = 0;
    public static final int QUOTED_PRINTABLE = 1;
    public static final int BASE64 = 2;
    private Header header;

    public MimeHeader() {
        this(new Header());
        this.setMimeType(new MimeType("text", "plain"));
    }

    public MimeHeader(Header header) {
        this.header = header;
    }

    public MimeHeader(String type, String subtype) {
        this.header = new Header();
        this.setMimeType(new MimeType(type, subtype));
    }

    public MimeType getMimeType() {
        try {
            return MimeTypeParser.parse(this.header.get("Content-Type"));
        }
        catch (ParserException e) {
            return new MimeType();
        }
    }

    public String getContentType() {
        return this.getMimeType().getType();
    }

    public String getContentSubtype() {
        return this.getMimeType().getSubtype();
    }

    public String getContentDisposition() {
        return this.header.get("Content-Disposition");
    }

    public String getContentParameter(String key) {
        return this.getParameter(this.header.get("Content-Type"), key);
    }

    public int getContentTransferEncoding() {
        String value = this.header.get("Content-Transfer-Encoding");
        if (value != null) {
            if (value.equalsIgnoreCase("quoted-printable")) {
                return 1;
            }
            if (value.equalsIgnoreCase("base64")) {
                return 2;
            }
        }
        return 0;
    }

    public String getContentID() {
        String result = this.header.get("Content-ID");
        if (result == null) {
            return this.header.get("Content-Id");
        }
        return result;
    }

    public String getContentDescription() {
        return this.header.get("Content-Description");
    }

    public String getDispositionParameter(String key) {
        return this.getParameter(this.header.get("Content-Disposition"), key);
    }

    protected String getParameter(String headerLine, String key) {
        if (headerLine == null) {
            return null;
        }
        Pattern parameterPattern = Pattern.compile(key + "\\s*=\\s*((\"([^\"]+)\")|([^\r\n\\s;]+))", 2);
        Matcher matcher = parameterPattern.matcher(headerLine);
        if (matcher.find()) {
            if (matcher.group(3) != null) {
                return matcher.group(3);
            }
            return matcher.group(4);
        }
        return null;
    }

    protected String appendParameter(String headerLine, String key, String value) {
        StringBuffer result = new StringBuffer(headerLine);
        result.ensureCapacity(headerLine.length() + 2 + key.length() + 1 + value.length());
        result.append("; ");
        result.append(key);
        result.append('=');
        result.append(value);
        return result.toString();
    }

    public String getFileName() {
        String result = null;
        result = this.getContentParameter("name");
        if (result != null) {
            return EncodedWord.decode(result).toString();
        }
        result = this.getDispositionParameter("filename");
        if (result != null) {
            return EncodedWord.decode(result).toString();
        }
        return result;
    }

    public String toString() {
        return this.header.toString();
    }

    public void putContentParameter(String key, String value) {
        this.header.set("Content-Type", this.appendParameter(this.header.get("Content-Type"), key, "\"" + value + "\""));
    }

    public void putDispositionParameter(String key, String value) {
        this.header.set("Content-Disposition", this.appendParameter(this.header.get("Content-Disposition"), key, "\"" + value + "\""));
    }

    public void setMimeType(MimeType type) {
        this.header.set("Content-Type", type.toString());
    }

    public void setContentDescription(String description) {
        this.header.set("Content-Description", description);
    }

    public void setContentDisposition(String disposition) {
        this.header.set("Content-Disposition", disposition);
    }

    public void setContentID(String id) {
        this.header.set("Content-ID", id);
    }

    public void setContentTransferEncoding(String encoding) {
        this.header.set("Content-Transfer-Encoding", encoding);
    }

    public int count() {
        return this.header.count();
    }

    public String get(String key) {
        return this.header.get(key);
    }

    public void set(String key, Object value) {
        this.header.set(key, value);
    }

    public Charset getCharset() {
        String charsetField = this.getContentParameter("charset");
        if (charsetField != null) {
            try {
                return Charset.forName(charsetField);
            }
            catch (IllegalCharsetNameException e) {
                return Charset.forName(System.getProperty("file.encoding"));
            }
            catch (UnsupportedCharsetException e) {
                return Charset.forName(System.getProperty("file.encoding"));
            }
        }
        return Charset.forName(System.getProperty("file.encoding"));
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public InputStream getInputStream() {
        return this.header.getInputStream();
    }
}

