/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.message;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import org.columba.ristretto.message.MimePart;
import org.columba.ristretto.message.MimeType;

public class MimeTree {
    MimePart rootMimeNode;

    public MimeTree(MimePart root) {
        this.rootMimeNode = root;
    }

    public MimePart get(int number) {
        List leafs = this.getAllLeafs();
        return (MimePart)leafs.get(number);
    }

    public int count() {
        if (this.rootMimeNode == null) {
            return 0;
        }
        return this.rootMimeNode.count();
    }

    public void clear() {
        this.rootMimeNode = null;
    }

    public List getAllLeafs() {
        return this.getLeafs(this.rootMimeNode);
    }

    public MimePart getFromAddress(Integer[] address) {
        if (Array.getLength(address) == 1 && address[0] == 0 && this.rootMimeNode.countChilds() == 0) {
            return this.rootMimeNode;
        }
        MimePart actPart = this.rootMimeNode;
        for (int i = 0; i < Array.getLength(address); ++i) {
            actPart = actPart.getChild(address[i]);
        }
        return actPart;
    }

    public MimePart getFirstTextPart(String preferedSubtype) {
        MimePart textPart = this.getFirstLeafWithContentType(this.rootMimeNode, "text");
        if (textPart == null) {
            return null;
        }
        if (preferedSubtype == null) {
            return textPart;
        }
        MimeType type = textPart.getHeader().getMimeType();
        if (type.getSubtype().equals(preferedSubtype)) {
            return textPart;
        }
        MimePart parent = textPart.getParent();
        if (parent != null && parent.getHeader().getMimeType().getSubtype().equals("alternative")) {
            List alternatives = this.getLeafsWithContentType(parent, "text");
            for (int i = 1; i < alternatives.size(); ++i) {
                MimePart nextTextPart = (MimePart)alternatives.get(i);
                if (!nextTextPart.getHeader().getMimeType().getSubtype().equals(preferedSubtype)) continue;
                return nextTextPart;
            }
        }
        return textPart;
    }

    public MimePart getFirstLeafWithContentType(MimePart root, String contentType) {
        MimePart result = null;
        if (root.countChilds() > 0) {
            for (int i = 0; i < root.countChilds(); ++i) {
                result = this.getFirstLeafWithContentType(root.getChild(i), contentType);
                if (result == null) continue;
                return result;
            }
        } else if (root.getHeader().getMimeType().getType().equals(contentType)) {
            return root;
        }
        return null;
    }

    public List getLeafsWithContentType(MimePart root, String contentType) {
        LinkedList<MimePart> result = new LinkedList<MimePart>();
        if (root.countChilds() > 0) {
            for (int i = 0; i < root.countChilds(); ++i) {
                result.addAll(this.getLeafsWithContentType(root.getChild(i), contentType));
            }
        } else if (root.getHeader().getMimeType().getType().equals(contentType)) {
            result.add(root);
        }
        return result;
    }

    public List getLeafs(MimePart root) {
        LinkedList<MimePart> result = new LinkedList<MimePart>();
        if (root.countChilds() > 0) {
            for (int i = 0; i < root.countChilds(); ++i) {
                result.addAll(this.getLeafs(root.getChild(i)));
            }
        } else {
            result.add(root);
        }
        return result;
    }

    public MimePart getRootMimeNode() {
        return this.rootMimeNode;
    }

    public void setRootMimeNode(MimePart rootMimeNode) {
        this.rootMimeNode = rootMimeNode;
    }
}

