/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.message.Address;
import org.columba.ristretto.parser.ParserException;

public class AddressParser {
    private static final Pattern addressTokenizerPattern = Pattern.compile("([^\\s]+?)(\\s|<|$)+");
    private static final Pattern trimPattern = Pattern.compile("[\"<]?([^\"<>]*)[\">]?");

    public static Address[] parseMailboxList(CharSequence mailboxList) throws ParserException {
        LinkedList<Address> result = new LinkedList<Address>();
        CharSequence[] tokens = AddressParser.tokenizeList(mailboxList);
        for (int i = 0; i < tokens.length; ++i) {
            result.add(AddressParser.parseAddress(tokens[i]));
        }
        Address[] a = new Address[result.size()];
        result.toArray((Object[])a);
        return a;
    }

    public static Address parseAddress(CharSequence address) throws ParserException {
        Matcher addressTokenizer = addressTokenizerPattern.matcher(address);
        ArrayList<String> tokens = new ArrayList<String>();
        while (addressTokenizer.find()) {
            tokens.add(addressTokenizer.group(1));
        }
        if (tokens.size() < 1) {
            throw new ParserException("No valid EMail address", address);
        }
        if (tokens.size() == 1) {
            return new Address(AddressParser.trim((String)tokens.get(0)));
        }
        StringBuffer name = new StringBuffer((String)tokens.get(0));
        for (int i = 1; i < tokens.size() - 1; ++i) {
            name.append(' ');
            name.append((String)tokens.get(i));
        }
        return new Address(AddressParser.trim(name), AddressParser.trim((String)tokens.get(tokens.size() - 1)));
    }

    private static String trim(CharSequence input) {
        Matcher trimMatcher = trimPattern.matcher(input);
        if (trimMatcher.matches()) {
            return trimMatcher.group(1);
        }
        return ((Object)input).toString();
    }

    private static CharSequence[] tokenizeList(CharSequence input) {
        int i;
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        boolean quoted = false;
        int start = 0;
        block4: for (i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\"': {
                    quoted ^= true;
                    continue block4;
                }
                case ',': {
                    if (quoted) continue block4;
                    result.add(input.subSequence(start, i));
                    start = i + 1;
                }
            }
        }
        if (start < i) {
            result.add(input.subSequence(start, i));
        }
        return result.toArray(new CharSequence[0]);
    }
}

