/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.parser;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.io.Source;
import org.columba.ristretto.message.Header;
import org.columba.ristretto.message.LocalMimePart;
import org.columba.ristretto.message.MimeHeader;
import org.columba.ristretto.message.MimeType;
import org.columba.ristretto.parser.CharSequenceSearcher;
import org.columba.ristretto.parser.HeaderParser;
import org.columba.ristretto.parser.ParserException;

public class BodyParser {
    private static final Pattern headerEndPattern = Pattern.compile("\r\n\r\n");
    private static final Pattern lineEndPattern = Pattern.compile("\r?\n|\r\n?");

    private BodyParser() {
    }

    public static void skipHeader(Source source) throws IOException {
        Matcher matcher = headerEndPattern.matcher(source);
        if (matcher.find()) {
            source.seek(matcher.end());
        }
    }

    public static LocalMimePart parseMimePart(MimeHeader header, Source message) throws IOException, ParserException {
        boolean endBoundaryFound = false;
        MimeType type = header.getMimeType();
        if (!type.getType().equals("multipart")) {
            return new LocalMimePart(header, message.fromActualPosition());
        }
        LocalMimePart multipart = new LocalMimePart(header, message.fromActualPosition());
        String boundary = header.getContentParameter("boundary");
        if (boundary == null) {
            throw new ParserException("Content-Type is multipart, but no boundary specified!");
        }
        CharSequenceSearcher boundarySearcher = new CharSequenceSearcher("--" + boundary);
        List foundBoundaries = boundarySearcher.match(message);
        Iterator it = foundBoundaries.iterator();
        while (it.hasNext()) {
            char suffix = message.charAt((Integer)it.next() + boundary.length() + 2);
            if (suffix == '\r' || suffix == '\n' || suffix == '-') continue;
            it.remove();
        }
        if (foundBoundaries.size() == 0) {
            throw new ParserException("No startboundary found: " + boundary, message);
        }
        it = foundBoundaries.iterator();
        int start = (Integer)it.next() + boundary.length() + 2;
        switch (message.charAt(start)) {
            case '\r': {
                if (message.charAt(++start) != '\n') break;
                ++start;
                break;
            }
            case '\n': {
                ++start;
            }
        }
        while (it.hasNext()) {
            int boundaryStart = (Integer)it.next();
            int boundaryEnd = boundaryStart + boundary.length() + 2;
            switch (message.charAt(boundaryStart - 1)) {
                case '\n': {
                    if (message.charAt(--boundaryStart) != '\n') break;
                    --boundaryStart;
                    break;
                }
                case '\r': {
                    --boundaryStart;
                }
            }
            switch (message.charAt(boundaryEnd)) {
                case '-': {
                    boundaryEnd += 4;
                    endBoundaryFound = true;
                    break;
                }
                case '\r': {
                    if (message.length() <= ++boundaryEnd || message.charAt(boundaryEnd) != '\n') break;
                    break;
                }
                case '\n': {
                    ++boundaryEnd;
                }
            }
            Source subSource = message.subSource(start, boundaryStart);
            Header subHeader = HeaderParser.parse(subSource);
            LocalMimePart subPart = BodyParser.parseMimePart(new MimeHeader(subHeader), subSource);
            subPart.setSource(subSource);
            multipart.addChild(subPart);
            start = ++boundaryEnd;
        }
        if (!endBoundaryFound) {
            int end = message.length();
            Source subSource = message.subSource(start, end);
            Header subHeader = HeaderParser.parse(subSource);
            LocalMimePart subPart = BodyParser.parseMimePart(new MimeHeader(subHeader), subSource);
            subPart.setSource(subSource);
            multipart.addChild(subPart);
        }
        return multipart;
    }
}

