/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CharSequenceSearcher {
    private int[] badCharacterSkip = new int[256];
    private int[] goodSuffixSkip;
    private char[] pattern;
    private int patternLength;

    public CharSequenceSearcher(String pattern) {
        this(pattern.toCharArray());
    }

    public CharSequenceSearcher(char[] pattern) {
        this.setPattern(pattern);
    }

    public void setPattern(char[] pattern) {
        this.pattern = pattern;
        this.patternLength = pattern.length;
        this.goodSuffixSkip = new int[this.patternLength + 1];
        this.initGoodSuffixSkipArray();
        this.initBadCharSkipArray();
    }

    private void initGoodSuffixSkipArray() {
        int j;
        int[] f = new int[this.patternLength + 1];
        f[this.patternLength] = j = this.patternLength + 1;
        for (int i = this.patternLength; i > 0; --i) {
            while (j <= this.patternLength && this.pattern[i - 1] != this.pattern[j - 1]) {
                if (this.goodSuffixSkip[j] == 0) {
                    this.goodSuffixSkip[j] = j - i;
                }
                j = f[j];
            }
            f[i - 1] = --j;
        }
        int p = f[0];
        for (j = 0; j <= this.patternLength; ++j) {
            if (this.goodSuffixSkip[j] == 0) {
                this.goodSuffixSkip[j] = p;
            }
            if (j != p) continue;
            p = f[p];
        }
    }

    private void initBadCharSkipArray() {
        Arrays.fill(this.badCharacterSkip, this.patternLength);
        for (int j = 0; j < this.patternLength - 1; ++j) {
            this.badCharacterSkip[this.pattern[j]] = this.patternLength - j - 1;
        }
    }

    public List match(CharSequence text) {
        int textLength = text.length();
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i <= textLength - this.patternLength) {
            int j;
            for (j = this.patternLength - 1; j >= 0 && this.pattern[j] == text.charAt(i + j); --j) {
            }
            if (j < 0) {
                result.add(new Integer(i));
                i += this.goodSuffixSkip[0];
                continue;
            }
            i += Math.max(this.goodSuffixSkip[j + 1], this.badCharacterSkip[text.charAt(i + j)] - this.patternLength + j + 1);
        }
        return result;
    }
}

